/*********************************************************

*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  T16N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "timer.h"
#include "string.h"
/*********************************************************
函数名: void PWM_Init(void)
描  述: pwm初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16Nx_Init(void)
{
    TIM_BaseInitStruType x;
    GPIO_InitStruType y;
    T16Nx_PWMInitStruType z;
    SCU_TIMEREN_Typedef t16n_mul_en;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));
    memset(&t16n_mul_en, 0, sizeof(t16n_mul_en));

    x.TIM_ClkS = TIM_ClkS_PCLK;                         //选择时钟：Pclk
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_PWM ;                         //设为PWM模式
    T16Nx_BaseInit(T16N2, &x);
    T16Nx_BaseInit(T16N3, &x);

    T16N2_PwmOut0_Enable();                             //使能T16N2端口输出0
    T16N2_PwmOut1_Enable();                             //使能T16N2端口输出1
    T16N3_PwmOut0_Enable();                             //使能T16N3端口输出0
    T16N3_PwmOut1_Enable();                             //使能T16N3端口输出1

    T16Nx_MAT0Out0Config(T16N2, TIM_Out_High);          //匹配0：输出高
    T16Nx_MAT1Out0Config(T16N2, TIM_Out_Low);           //匹配1：输出低
    T16Nx_MAT2Out1Config(T16N2, TIM_Out_High);          //匹配2：输出高
    T16Nx_MAT3Out1Config(T16N2, TIM_Out_Low);           //匹配3：输出低

    T16Nx_MAT0Out0Config(T16N3, TIM_Out_High);          //匹配0：输出高
    T16Nx_MAT1Out0Config(T16N3, TIM_Out_Low);           //匹配1：输出低
    T16Nx_MAT2Out1Config(T16N3, TIM_Out_High);          //匹配2：输出高
    T16Nx_MAT3Out1Config(T16N3, TIM_Out_Low);           //匹配3：输出低

    z.T16Nx_MOE0 = ENABLE;
    z.T16Nx_MOE1 = ENABLE;
    z.T16Nx_POL0 = POSITIVE;
    z.T16Nx_POL1 = POSITIVE;
    T16Nx_PWMOutConfig(T16N2, &z);                      //配置输出
    T16Nx_PWMOutConfig(T16N3, &z);                      //配置输出

    T16Nx_SetPREMAT(T16N2, 16);                         //预分频
    T16Nx_SetCNT(T16N2, 0);
    T16Nx_SetMAT0(T16N2, 800);
    T16Nx_SetMAT1(T16N2, 1200);                         //占空比20%
    T16Nx_SetMAT2(T16N2, 600);
    T16Nx_SetMAT3(T16N2, 1400);                         //占空比40%
    T16Nx_SetTOP(T16N2, 2000);                          //控制周期

    T16Nx_SetPREMAT(T16N3, 16);                         //预分频
    T16Nx_SetCNT(T16N3, 0);
    T16Nx_SetMAT0(T16N3, 400);
    T16Nx_SetMAT1(T16N3, 1600);                         //占空比60%
    T16Nx_SetMAT2(T16N3, 200);
    T16Nx_SetMAT3(T16N3, 1800);                         //占空比80%
    T16Nx_SetTOP(T16N3, 2000);                          //控制周期

    NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, DISABLE);
    NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, DISABLE);

    T16Nx_MAT0ITConfig(T16N2, TIM_Go_Int);              //匹配0：继续计数
    T16Nx_MAT1ITConfig(T16N2, TIM_Go_Int);              //匹配1：继续计数
    T16Nx_MAT2ITConfig(T16N2, TIM_Go_Int);              //匹配2：继续计数
    T16Nx_MAT3ITConfig(T16N2, TIM_Go_Int);              //匹配3：继续计数

    T16Nx_MAT0ITConfig(T16N3, TIM_Go_Int);              //匹配0：继续计数
    T16Nx_MAT1ITConfig(T16N3, TIM_Go_Int);              //匹配1：继续计数
    T16Nx_MAT2ITConfig(T16N3, TIM_Go_Int);              //匹配2：继续计数
    T16Nx_MAT3ITConfig(T16N3, TIM_Go_Int);              //匹配3：继续计数

    T16Nx_ITConfig(T16N2, TIM_IT_MAT0, DISABLE);        //可选择是否使能中断
    T16Nx_ITConfig(T16N2, TIM_IT_MAT1, DISABLE);
    T16Nx_ITConfig(T16N2, TIM_IT_MAT2, DISABLE);
    T16Nx_ITConfig(T16N2, TIM_IT_MAT3, DISABLE);

    T16Nx_ITConfig(T16N3, TIM_IT_MAT0, DISABLE);        //可选择是否使能中断
    T16Nx_ITConfig(T16N3, TIM_IT_MAT1, DISABLE);
    T16Nx_ITConfig(T16N3, TIM_IT_MAT2, DISABLE);
    T16Nx_ITConfig(T16N3, TIM_IT_MAT3, DISABLE);

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_3;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = GPIO_PUE_Input_Disable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOB, GPIO_Pin_8, &y);                   //PB8
    GPIO_Init(GPIOB, GPIO_Pin_9, &y);                   //PB9
    GPIO_Init(GPIOB, GPIO_Pin_2, &y);                   //PB2
    GPIO_Init(GPIOB, GPIO_Pin_3, &y);                   //PB3

    /* SCU同步启动T16N2、T16N3 */
    t16n_mul_en.T16N2EN = ENABLE;
    t16n_mul_en.T16N3EN = ENABLE;
    SCU_MultTimerEnable(t16n_mul_en);
}
