/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2023/10/11
*描  述:  IIC E2PROM demo
          引脚连接：
          ------------------------
          IIC EEPROM:
          ------------------------
          PB28 - SCL
          PB29 - SDA
          ------------------------
          UART:
          ------------------------
          TXD - PA6
          ------------------------
          本例程使用的E2PROM是MCU内部的P24C08D(1kBytes)
          配合ESBridge打印串口数据
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint8_t wbuf[20];
uint8_t rbuf[20];

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             /* 打开所有外设时钟 */
    SysTickInit();

    e2prom_init();

    e2prom_reset();

    /* 在E2PROM的0x13地址上写入0xC */
    e2prom_byte_write(0x13, 12, rom_size_1k_byte);
    printf("write finished, write content: 12\r\n");

    /* 从E2PROM的0x13地址上读取一字节数据 */
    e2prom_random_read(0x13, rbuf, rom_size_1k_byte);
    printf("content readout: %d\r\n\r\n", rbuf[0]);

    /* 在E2PROM的0xA0地址处写入essemi */
    memcpy(wbuf, "essemi", 6);
    e2prom_page_write(0xA0, wbuf, page_size_16_byte, rom_size_1k_byte);
    printf("write finished, write content: essemi\r\n");

    /* 从E2PROM的0xA0地址处读取6字节数据 */
    e2prom_sequential_read(0xA0, rbuf, 6, rom_size_1k_byte);
    printf("content readout: %s\r\n\r\n", rbuf);

    while (1)
    {
    }
}

