/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  IIC中断演示主程序
          本程序为主机程序，负责发起写和读，从从机中读取9个字节数据，然后发给从机。
          SCL:PA31, SDA:PA30
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint8_t rxbuf[9];
uint8_t txbuf[9];

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             /* 打开所有外设时钟 */
    SysTickInit();

    while (1)
    {
        IICReadBuf(SLAVE_ADDR, rxbuf, 9);
        memcpy(txbuf, rxbuf, 9);
        Delay1ms(100);
        IICWriteBuf(SLAVE_ADDR, txbuf, 9);
        Delay1ms(100);
    }
}

