/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_ees_descriptor.c
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : Descriptor for EES
**********************************************************************************************************************/

/**********************************************************************************************************************
 Includes   <System Includes> , "Project Includes"
 *********************************************************************************************************************/
#include "r_ees_types.h"
#include "r_ees_descriptor.h"
#include "r_ees_user_types.h"


/**********************************************************************************************************************
 Const variables
 *********************************************************************************************************************/

/* EES descriptor */
#define  R_EES_START_SECTION_EES_CNST
#include "r_ees_memmap.h"
__far const uint8_t g_ar_u08_ees_descriptor[R_EES_VALUE_U08_VAR_NO + 2u] =
{
  (uint8_t)(R_EES_VALUE_U08_VAR_NO), /* variable count   */
  (uint8_t)(sizeof(type_A)),         /* id=1             */
  (uint8_t)(sizeof(type_B)),         /* id=2             */
  (uint8_t)(sizeof(type_C)),         /* id=3             */
  (uint8_t)(sizeof(type_D)),         /* id=4             */
  (uint8_t)(sizeof(type_E)),         /* id=5             */
  (uint8_t)(sizeof(type_F)),         /* id=6             */
  (uint8_t)(sizeof(type_X)),         /* id=7             */
  (uint8_t)(sizeof(type_Z)),         /* id=8             */
  (uint8_t)(0x00u)                   /* zero terminator  */
};
#define  R_EES_END_SECTION_EES_CNST
#include "r_ees_memmap.h"


/* ----------------------------------------------------------------------------------------------------------------- */
/* ------------                                                                                         ------------ */
/* ------------      B E G I N    O F    U N T O U C H A B L E    D E C L A R A T I O N    A R E A      ------------ */
/* ------------                                                                                         ------------ */
/* ----------------------------------------------------------------------------------------------------------------- */
/**********************************************************************************************************************
 Exported global variables
 *********************************************************************************************************************/
/* for EES(EXRFD) */
#define  R_EES_START_SECTION_EES_CNST
#include "r_ees_memmap.h"
__far const st_ees_exrfd_descriptor_t g_st_ees_exrfd_descriptor =
{
    (uint16_t) R_EES_EXRFD_VALUE_U16_PHYSICAL_BLOCK_SIZE,
    (uint8_t)  R_EES_EXRFD_VALUE_U08_PHYSICAL_BLOCKS_PER_VIRTUAL_BLOCK,
    (uint8_t)  R_EES_EXRFD_VALUE_U08_POOL_VIRTUAL_BLOCKS
};
#define  R_EES_END_SECTION_EES_CNST
#include "r_ees_memmap.h"

#define  R_EES_START_SECTION_EES_VAR
#include "r_ees_memmap.h"
/* EES RAM reference table */
__near uint16_t g_ar_u16_ram_ref_table[R_EES_VALUE_U08_VAR_NO];
#define  R_EES__END_SECTION_EES_VAR
#include "r_ees_memmap.h"

/* ----------------------------------------------------------------------------------------------------------------- */
/* ------------                                                                                         ------------ */
/* ------------        E N D    O F    U N T O U C H A B L E    D E C L A R A T I O N    A R E A        ------------ */
/* ------------                                                                                         ------------ */
/* ----------------------------------------------------------------------------------------------------------------- */
