/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_typedefs.h
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : standard types definitions
**********************************************************************************************************************/

#ifndef R_TYPEDEFS_H
#define R_TYPEDEFS_H

/*********************************************************************************************************************
 * standard types definitions
 *********************************************************************************************************************/

/* Compilers must have __STDC_VERSION__ due to requirement in language standard */
#if ((defined __STDC_VERSION__) && (__STDC_VERSION__ >= 199901L))
#include <stdint.h>
#include <stdbool.h>
#else
typedef signed char        int8_t;
typedef unsigned char      uint8_t;
typedef signed short       int16_t;
typedef unsigned short     uint16_t;
typedef signed long        int32_t;
typedef unsigned long      uint32_t;
typedef unsigned char      rBool_t;

#define bool               rBool_t
#define false              (0)
#define true               (1)

#define INT8_MIN           (-128)
#define INT16_MIN          (-32768)
#define INT32_MIN          (-2147483647 - 1)

#define INT8_MAX           (127)
#define INT16_MAX          (32767)
#define INT32_MAX          (2147483647)

#define UINT8_MAX          (255u)
#define UINT16_MAX         (65535u)
#define UINT32_MAX         (4294967295u)

#endif    /* ((defined __STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)) */
#endif    /* #ifndef R_TYPEDEFS_H   */
