/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_ees_device.h
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : EES device header file
**********************************************************************************************************************/

#ifndef R_EES_DEVICE_H
#define R_EES_DEVICE_H

#include "es_flash_common_api.h"

/* Defines */
#define R_EES_EXRFD_VALUE_U32_DF_BASE_ADDR                         (EEPROM_START_ADDRESS)

#define R_EES_EXRFD_VALUE_U32_DEVICE_MEMORY_LIMIT                  ((EEPROM_START_ADDRESS) + (EEPROM_FLASH_SIZE))
#define R_EES_EXRFD_VALUE_U32_DF_MEMORY_LIMIT                      (EEPROM_FLASH_SIZE)

#define R_EES_EXRFD_VALUE_U08_MASK1_FSQ_STATUS_ERR_CFDF_SEQUENCER  (0x10u)
#define R_EES_EXRFD_VALUE_U08_MASK1_FSQ_STATUS_ERR_ERASE           (0x01u)
#define R_EES_EXRFD_VALUE_U08_MASK1_FSQ_STATUS_ERR_WRITE           (0x02u)
#define R_EES_EXRFD_VALUE_U08_MASK1_FSQ_STATUS_ERR_BLANKCHECK      (0x08u)

#endif /* end of R_EES_DEVICE_H */
