/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_ees_defines.h
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : EES defines header file
**********************************************************************************************************************/

#ifndef R_EES_DEFINES_H
#define R_EES_DEFINES_H

/* Defines */
#define R_EES_VALUE_U08_INIT_VARIABLE                               (0x00u)
#define R_EES_VALUE_U16_INIT_VARIABLE                               (0x0000u)
#define R_EES_VALUE_U32_INIT_VARIABLE                               (0x00000000uL)

#define R_EES_VALUE_U01_MASK0_1BIT                                  (0u)
#define R_EES_VALUE_U01_MASK1_1BIT                                  (1u)
#define R_EES_VALUE_U08_MASK0_8BIT                                  (0x00u)
#define R_EES_VALUE_U08_MASK1_8BIT                                  (0xFFu)

#ifndef ES_FLASH_EMULATE_EEPROM_WRITE_WORD_ONCE_DISABLE

#define R_EES_EXRFD_VALUE_U08_PHYSICAL_BLOCKS_PER_VIRTUAL_BLOCK_MIN (0x01u)
#define R_EES_EXRFD_VALUE_U08_POOL_VIRTUAL_BLOCKS_MIN               (0x02u)
#define R_EES_VALUE_U08_EES_VARS_MIN                                (0x01u)
#define R_EES_VALUE_U08_EES_VARS_MAX                                (0xFEu)
#define R_EES_VALUE_U08_HEADER_SIZE                                 (0x20u)
#define R_EES_VALUE_U08_SEPARATOR_SIZE                              (0x08u)
#define R_EES_VALUE_U08_REFERENCE_ENTRY_SIZE                        (0x08u)
#define R_EES_VALUE_U08_A_FLAG_INDEX                                (0x00u)
#define R_EES_VALUE_U08_B_FLAG_INDEX                                (0x04u)
#define R_EES_VALUE_U08_BD_FLAG_INDEX                               (0x05u)
#define R_EES_VALUE_U08_I_FLAG_INDEX                                (0x08u)
#define R_EES_VALUE_U08_X_FLAG_INDEX                                (0x0Cu)
#define R_EES_VALUE_U08_A_FLAG_ORDER_MIN                            (0x01u)
#define R_EES_VALUE_U08_A_FLAG_ORDER_MAX                            (0x03u)
#define R_EES_VALUE_U08_SOR_INDEX                                   (0x00u)
#define R_EES_VALUE_U08_EOR_INDEX                                   (0x04u)
#define R_EES_VALUE_U08_EORD_INDEX                                  (0x05u)
#define R_EES_VALUE_U08_REFRESH_RETRY                               (0x01u)
#define R_EES_VALUE_U08_EXRFD_DATA_BUFFER_SIZE                      (0x20u)

#else

#define R_EES_EXRFD_VALUE_U08_PHYSICAL_BLOCKS_PER_VIRTUAL_BLOCK_MIN (0x01u)
#define R_EES_EXRFD_VALUE_U08_POOL_VIRTUAL_BLOCKS_MIN               (0x02u)
#define R_EES_VALUE_U08_EES_VARS_MIN                                (0x01u)
#define R_EES_VALUE_U08_EES_VARS_MAX                                (0xFEu)
#define R_EES_VALUE_U08_HEADER_SIZE                                 (0x08u)
#define R_EES_VALUE_U08_SEPARATOR_SIZE                              (0x02u)
#define R_EES_VALUE_U08_REFERENCE_ENTRY_SIZE                        (0x03u)
#define R_EES_VALUE_U08_A_FLAG_INDEX                                (0x00u)
#define R_EES_VALUE_U08_B_FLAG_INDEX                                (0x01u)
#define R_EES_VALUE_U08_BD_FLAG_INDEX                               (0x02u)
#define R_EES_VALUE_U08_I_FLAG_INDEX                                (0x03u)
#define R_EES_VALUE_U08_X_FLAG_INDEX                                (0x04u)
#define R_EES_VALUE_U08_A_FLAG_ORDER_MIN                            (0x01u)
#define R_EES_VALUE_U08_A_FLAG_ORDER_MAX                            (0x03u)
#define R_EES_VALUE_U08_SOR_INDEX                                   (0x00u)
#define R_EES_VALUE_U08_EOR_INDEX                                   (0x01u)
#define R_EES_VALUE_U08_EORD_INDEX                                  (0x02u)
#define R_EES_VALUE_U08_REFRESH_RETRY                               (0x01u)
#define R_EES_VALUE_U08_EXRFD_DATA_BUFFER_SIZE                      (0x08u)

#endif
/* Internal test macro */
#define R_EES_EXRFD_INTERNAL_CODE_FLASH_MODE_ERASE
#define R_EES_EXRFD_INTERNAL_CODE_FLASH_MODE_WRITE
#define R_EES_EXRFD_INTERNAL_CODE_FLASH_MODE_BLANKCHECK
#define R_EES_EXRFD_INTERNAL_CODE_FLASH_MODE_READ
#define R_EES_EXRFD_INTERNAL_CODE_FLASH_MODE_FINISH
#define R_EES_EXRFD_INTERNAL_CODE_CMD_ERASE
#define R_EES_EXRFD_INTERNAL_CODE_CMD_WRITE
#define R_EES_EXRFD_INTERNAL_CODE_CMD_BLANKCHECK
#define R_EES_EXRFD_INTERNAL_CODE_CMD_READ
#define R_EES_EXRFD_INTERNAL_CODE_FSQ_STATUS
#define R_EES_EXRFD_INTERNAL_CODE_FSQ_STEP2_STATUS
#define R_EES_EXRFD_INTERNAL_CODE_EXEC_STATE

#endif /* end of R_EES_DEFINES_H */
