/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  GPIO外部中断演示主程序
*         PB10每产生一次外部中断，PA12电平翻转一次
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"
#include "string.h"
/***************************************************************
 函数名：void PINTx_Init(void)
 描  述：端口中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void PINTx_Init(void)
{
    GPIO_InitStruType x;
    memset(&x, 0, sizeof(x));
    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Enable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    x.GPIO_FLT = GPIO_TYP_FLT_ENABLE;
    GPIO_Init(GPIOB, GPIO_Pin_10, &x);  //使能端口的20ns滤波功能

#if defined(ES8H0384) || defined(ES8H0364) || defined(ES8H0394) || defined(ES8H0184)
    PINT_Filter_Config(PINT0, PINT_FLTCLK_LRC, PINT_FLTCNT_4, ENABLE);  //配置PINT滤波功能
#endif
    PINT_Config(PINT0, PINT_SEL5, PINT_Trig_Rise);
    PINT0_MaskDisable();
    PINT0_Enable();
    NVIC_Init(NVIC_PINT0_IRQn, NVIC_Priority_1, ENABLE);

    return;
}

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟
    DeviceClockAllEnable();             //打开所有外设时钟

    LightInit();                        //指示灯初始化
    PINTx_Init();

    while (1)
    {

    }
}
