/*********************************************************
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/8
*描  述:  CRC演示程序
          给定数据，计算CRC值，与目标值进行对比
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"
#include "string.h"
int test_crc(void)
{
    uint8_t i;
    uint8_t in_data[6] = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66};
    uint32_t out_data = 0;
    CRC_CONValueStrutType x;
    memset(&x, 0, sizeof(x));
    x.xorout = CRC_XOROUT_NORMAL;                //数据输出不取反
    x.refout = CRC_REFOUT_REVERSE;               //数据输出倒序
    x.refin = CRC_REFIN_REVERSE;                 //数据输入倒序
    x.byte = CRC_BYTE_BYTE;                      //字节位宽
    x.mode = CRC_MOD_CRC16;                      //CRC16模型
    x.flash = DISABLE;                           //不访问Flash
    x.init_data_type = CRC_INIT_DATA_ALL_0;      //初始为全0
    x.hs_type = CRC_HS_TYPE_DISABLE;             //禁止高速模式
    CRC_Init(&x);

    for (i = 0; i < 6; i++)
    {
        CRC_WriteData(in_data[i]);
        CRC_Trig(CRC_TRIG_USER_VERIFY);  //用户校验模式
    }

    out_data = CRC_GetData();

    if (out_data == 0x6D0B)
        return 1;
    else
        return 0;
}

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();
    DeviceClockAllEnable();

    while (test_crc() == 0);

    while (1);
}





