/*********************************************************
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/9
*描  述:  ADC演示主程序
          软件控制ADC，使用中断转换：
          采样AIN1(PB6)模拟信号，转换值通过UART打印，TX:PA8
          使用printf需以下步骤：
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
          2、IAR中library选择full
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include <stdio.h>
#include "main.h"

uint8_t g_adc_flag;
uint32_t g_adc_data;

int main(void)
{
    SystemHRCSelect(SCU_HRC_48M);       //HRC选择48MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟

    SysTickInit();
    UARTInit();                         //UART初始化(115200,8,NO,1)

    ADC0_UserInit();

    ADC_SoftStart();                                    /* 软件开启采样 */
    ADC_SoftStop();                                     /* 软件停止采样 */

    while (1)
    {
        if (1 == g_adc_flag)                             //中断读取采样ADC数值
        {
            g_adc_flag = 0;
            printf("AD value of AIN1: %d mV\r\n", g_adc_data);     //打印ADC值

            Delay1ms(2000);

            ADC_SoftStart();                                    /* 软件开启采样 */
            ADC_SoftStop();                                     /* 软件停止采样 */
        }
    }
}





