/***************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **************************************************************************/
#include "irqhandler.h"

extern uint16_t meanvalue;

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}
void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

/*********************************************************
函数名: void T16N3_IRQHandler(void)
描  述: T16N3定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N3_IRQHandler(void)
{

}
/*********************************************************
函数名: void ADC_IRQHandler(void)
描  述: ADC定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void ADC_IRQHandler(void)
{
    if ((ADC_GetFlagStatus(ADC_IF_ACPOV) == SET) && (ADC_GetITStatus(ADC_IE_ACPOV) == SET))
    {
        ADC_ClearIFStatus(ADC_IF_ACPOV);
        meanvalue = ADC_GetACPMeanValue();
        GPIOA_SetBit(GPIO_Pin_12);
    }

    if ((ADC_GetFlagStatus(ADC_IF_ACPMIN) == SET) && (ADC_GetITStatus(ADC_IE_ACPMIN) == SET))
    {
        ADC_ClearIFStatus(ADC_IF_ACPMIN);
        GPIOA_ResetBit(GPIO_Pin_12);
    }

    if ((ADC_GetFlagStatus(ADC_IF_ACPMAX) == SET) && (ADC_GetITStatus(ADC_IE_ACPMAX) == SET))
    {
        ADC_ClearIFStatus(ADC_IF_ACPMAX);
        GPIOA_ResetBit(GPIO_Pin_12);
    }

    if ((ADC_GetFlagStatus(ADC_IF) == SET) && (ADC_GetITStatus(ADC_IE) == SET))
    {
        ADC_ClearIFStatus(ADC_IF);
    }
}


