/*********************************************************
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/3
*描  述:  ADC演示主程序
          自动转换比较功能，采用12位分辨率，当转换结果不在阈值范围内将翻转PA12电平，采样的平均值通过UART打印
          连线：
          PA8 - TXD
          PB6  - AD
          使用printf需以下步骤：
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、iDesigner #define __PRINTF_USE_UART3__
          4、IAR选择library为full
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include <stdio.h>
#include "main.h"

uint16_t meanvalue;

int main(void)
{
    SystemHRCSelect(SCU_HRC_48M);       //HRC选择48MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟

    SysTickInit();
    LightInit();
    UARTInit();                         //UART初始化(115200,8,NO,1)

    ADC0_UserInit();

    /* 配置自动比较功能，启动ADC */
    ADCACPConfig();
    ADC_Start();

    while (1)
    {
        printf("AD value of AIN1: %d\r\n", meanvalue);     //打印ADC值

        Delay1ms(2000);
    }
}





