/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tk_lib_lp.c
*  :	AE Team
*  :	V1.0
*  :	2024/03/18
*  :	شӳ
*  ע:    ESD-TKT-7P2124-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"
const unsigned char reg_port_lp[20] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x40, 0x80, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x10, 0x20};
const unsigned char ch_table_lp[TK_NUM_LP] =
{
#if TK_NUM_LP >0
    TK_CHANNEL_LP_0,
#endif
#if TK_NUM_LP >1
    TK_CHANNEL_LP_1,
#endif
#if TK_NUM_LP >2
    TK_CHANNEL_LP_2,
#endif
#if TK_NUM_LP >3
    TK_CHANNEL_LP_3,
#endif
#if TK_NUM_LP >4
    TK_CHANNEL_LP_4,
#endif
#if TK_NUM_LP >5
    TK_CHANNEL_LP_5,
#endif
#if TK_NUM_LP >6
    TK_CHANNEL_LP_6,
#endif
#if TK_NUM_LP >7
    TK_CHANNEL_LP_7,
#endif
#if TK_NUM_LP >8
    TK_CHANNEL_LP_8,
#endif
#if TK_NUM_LP >9
    TK_CHANNEL_LP_9,
#endif
#if TK_NUM_LP >10
    TK_CHANNEL_LP_10,
#endif
#if TK_NUM_LP >11
    TK_CHANNEL_LP_11,
#endif
#if TK_NUM_LP >12
    TK_CHANNEL_LP_12,
#endif
#if TK_NUM_LP >13
    TK_CHANNEL_LP_13,
#endif
#if TK_NUM_LP >14
    TK_CHANNEL_LP_14,
#endif
#if TK_NUM_LP >15
    TK_CHANNEL_LP_15,
#endif
#if TK_NUM_LP >16
    TK_CHANNEL_LP_16,
#endif
#if TK_NUM_LP >17
    TK_CHANNEL_LP_17,
#endif
#if TK_NUM_LP >18
    TK_CHANNEL_LP_18,
#endif
#if TK_NUM_LP >19
    TK_CHANNEL_LP_19
#endif
};

const unsigned int thd_table_lp[TK_NUM_LP] =
{
#if TK_NUM_LP >0
    TK_THD_CHANNEL_LP_0,
#endif
#if TK_NUM_LP >1
    TK_THD_CHANNEL_LP_1,
#endif
#if TK_NUM_LP >2
    TK_THD_CHANNEL_LP_2,
#endif
#if TK_NUM_LP >3
    TK_THD_CHANNEL_LP_3,
#endif
#if TK_NUM_LP >4
    TK_THD_CHANNEL_LP_4,
#endif
#if TK_NUM_LP >5
    TK_THD_CHANNEL_LP_5,
#endif
#if TK_NUM_LP >6
    TK_THD_CHANNEL_LP_6,
#endif
#if TK_NUM_LP >7
    TK_THD_CHANNEL_LP_7,
#endif
#if TK_NUM_LP >8
    TK_THD_CHANNEL_LP_8,
#endif
#if TK_NUM_LP >9
    TK_THD_CHANNEL_LP_9,
#endif
#if TK_NUM_LP >10
    TK_THD_CHANNEL_LP_10,
#endif
#if TK_NUM_LP >11
    TK_THD_CHANNEL_LP_11,
#endif
#if TK_NUM_LP >12
    TK_THD_CHANNEL_LP_12,
#endif
#if TK_NUM_LP >13
    TK_THD_CHANNEL_LP_13,
#endif
#if TK_NUM_LP >14
    TK_THD_CHANNEL_LP_14,
#endif
#if TK_NUM_LP >15
    TK_THD_CHANNEL_LP_15,
#endif
#if TK_NUM_LP >16
    TK_THD_CHANNEL_LP_16,
#endif
#if TK_NUM_LP >17
    TK_THD_CHANNEL_LP_17,
#endif
#if TK_NUM_LP >18
    TK_THD_CHANNEL_LP_18,
#endif
#if TK_NUM_LP >19
    TK_THD_CHANNEL_LP_19
#endif
};

sbit tk_sleep_flag; //1: ˯ģʽ 0: ģʽ
sbit tk_value_get_lp;
uint tk_md2average_backup[TK_NUM_LP];
/*********************************************************
:	void prepareforsleepmode_init(void)
  : ˯ߵĳʼ׼
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void prepareforsleepmode_init(void)
{
	unsigned char i,j,k;
	//رʹģ鼰жʹ
	GIE = 0;        //رжʹ

	TKEN = 0;
	TKGO = 0;
	TKIE = 0;
	TKIF = 0;
	TKINTF &= 0xF0;     //жϱ־			
	TKCHSL = (unsigned char)(TK_CHANNEL_SEL_LP & 0xFF);
	TKCHSM = (unsigned char)((TK_CHANNEL_SEL_LP>>8) & 0xFF);
	TKCHSH = (unsigned char)((TK_CHANNEL_SEL_LP>>16) & 0xFF);
	TKDIST0 = 0;	//֤˯ߵһ֡ŵ
	TKDIST1 = 0;
	TKDIST2 = 1;
	EXTEN = 1;

	//ùܽŷ״̬ƽ  
	PAS = 0;
	PAT = 0;
	PA = 0;
	PBS = 0;
	PBT = 0;
	PB = 0;
	PCS = 0;
	PCT = 0;
	PC = 0;
	PES = 0;
	PET = 0;
	PE = 0;

	for(i = 0;i < TK_NUM_LP;i++) {
		j = (ch_table_lp[i] & 0x1F);
		j = reg_port_lp[j];
		k = (ch_table_lp[i] & 0xE0);
		if(k == PA_PORT) {            // PA
			//PAT |= j;//
			PAS |= j;//ģ
		}
		else if(k == PB_PORT) {       // PB
			//PBT |= j;
			PBS |= j;
		}
		else if(k == PE_PORT) {       // PE
			//PET |= j;
			PES |= j;
		}
	}

	//Cx
	PCT0 = 1;
	PCS0 = 1;

	for(i = 0;i < TK_NUM_LP;i++)
	{
		tk_md2average_backup[i] = 0;
	}	

#if PINT_WAKE_FUNC == ON
	PBT7 = 1;	//PB7Ϊ
	PBS7 = 0;	//PB7ڳʼΪֶ˿

	PEG02 = 1;	//˫شPINTж
	PIE0 = 1;	//ʹPINT0ж
#endif

#if KINT_WAKE_FUNC == ON
	PBT6 = 1;	//PB6Ϊ
	PBS6 = 0;	//PB6ڳʼΪֶ˿
	PBPU6 = 1;
	PB6 = 1;

	KMSK0 = 1;	//KIN0벻
	KIF = 0;
	KIE = 1;	//ʹⲿж
#endif
	CLKG &= 0x18;
}

/*********************************************************
:	void wakeupfromsleepmode_init(void)
  : Ѻĳʼ ָʱ״̬ʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void wakeupfromsleepmode_init(void)
{
	uchar i;

#if PINT_WAKE_FUNC == ON
	PIE0 = 0;	//رPINT0ж
#endif
#if KINT_WAKE_FUNC == ON
	KMSK0 = 0;	//KIN0
	KIF = 0;
	KIE = 0;	//رⲿж
#endif
	CLKG |= 0xEF;
	TKCHSL = (uchar)(TK_CHANNEL_SEL & 0xFF);
	TKCHSM = (uchar)((TK_CHANNEL_SEL>>8) & 0xFF);
	TKCHSH = (uchar)((TK_CHANNEL_SEL>>16) & 0xFF);
	TKCTL4 = TK_REG_TKCTL4;
	EXTEN = 0;
	TKIE = 1;
	TKIF = 0;
	TKEN = 1;

	tkscan_cnt  = 0;	
	base_up_cnt = 0;
	tk_value_get = 0;
	timer_10ms = 0;
	lock_avg_cnt = 0;
	tk_sleep_flag = 0;

	for(i = 0;i < TK_NUM_LP;i++)
	{
		tk_md2average_backup[i] = 0;
	}	

	wdt_set(WDT_4080MS);

	GIE  = 1;
	TKGO = 1;
}

/*********************************************************
:	void TKStandby(void)
  :	TK˯ɨӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_standby(void)
{
	uchar *ptr;
	uchar i;
	uint cmp1 = 0;
	uint cmp2 = 0;
	union {
		uchar dl[2];
		uint  data;
	}tkdata;

	wdt_set(WDT_4080MS);
	__Asm IDLE;		 //HRCԶر LRC
	TKVREF_EN = 1;	 //idleӲ Ѻλ
	__Asm CWDT;
	wdt_set(WDT_CLOSE);

#if PINT_WAKE_FUNC == ON
	if((PIF0 == 1) && (PIE0 == 1))
	{
		PIF0 = 0;
		//TKVREF_EN ȶҪʱ ܻѹʱ豣֤200us
		for(i = 0; i < 150; i++)	//160us@16M
		{
			nop();
			clr_wdt();    //忴Ź
		}
		customer_wakeupfromsleepmode_init();
		return;
	}
#endif

#if KINT_WAKE_FUNC == ON
	if((KIF == 1) && (KIE == 1))
	{
		PB6 = 1;
		KIF = 0;
		//TKVREF_EN ȶҪʱ ܻѹʱ豣֤200us
		for(i = 0; i < 150; i++)	//160us@16M
		{
			nop();
			clr_wdt();    //忴Ź
		}
		customer_wakeupfromsleepmode_init();
		return;
	}
#endif

	while(TKIF == 0);//ȴɨ
	TKIF = 0;
	tk_value_get_lp = 0;
	if(DONEIF)		
	{
		tk_value_get_lp = 1;
	}
	TKINTF &= 0xF0;         //TKжϱ־
	//TKVREF_EN ȶҪʱ С8ʱע ܻѹʱ豣֤200us
	for(i = 0; i < 50; i++) {	//110us@16M
		__Asm NOP;
		__Asm CWDT;
	}
	if(tk_value_get_lp)
	{
		for(i = 0;i < TK_NUM_LP;i++)
		{
			ptr = 0x60C0;
			ptr += (ch_table_lp[i] & 0x1F)<<1;
			tkdata.dl[0] = *ptr;
			tkdata.dl[1] = *(ptr+1);
			cmp1 = (uint)tkdata.data;
			if(cmp1 != 0)
			{
				cmp2 = (uint)(tk_md2average_backup[i] + thd_table_lp[i]);
				if(cmp1 > cmp2)
				{
					if(tk_md2average_backup[i] == 0)
					{
						tk_md2average_backup[i] = cmp1;
					}
					else
					{
						//TK_state |= 1<<i;
						//TK_Value_Arr[i].tk_value_filter = TK_Value_Arr[i].tk_value_average + Threshold_table[i] + 10;
						//TK_Value_Arr[i].tk_value_origin += Threshold_table[i] + 10;
						//TK_Value_Arr[i].tk_press_table = TK_Debounce_press + 2;
						//TK_Value_Arr[i].tk_release_table = 0;	
						wakeupfromsleepmode_init();
						break;
					}
				}
				if(tk_md2average_backup[i] != 0)
				{
					if(cmp1 < tk_md2average_backup[i])
					{
						tk_md2average_backup[i]--;
					}
					if(cmp1 > tk_md2average_backup[i])
					{
						tk_md2average_backup[i]++;
					}
				}
			}
		}
	}
}

