/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  double precision pwm
*  :  AE Team
*  :  V1.0
*  :  2022/04/21
*  :  T21˫PWM
          1.ʹоƬ˫PWMģʽPA2˿ڼPA1˿ʵΪ100us~50usռձȷֱΪ25%50%ķڷĴεݼ50us
            ٽװأռձȲ䣬Դη
          2.оƬʹ16MHzϵͳʱӣӦT21ʱʱԴΪ1/16MHzT21ԤƵã1:1T21ڼĴT21Pʼֵ㹫ʽӦΪ
            PWM100us = T21P 1/16MHz 1ԤƵȣT21PֵPERIOD = 16000x0640
            PWM50us = T21PR 1/16MHz 1ԤƵȣT21RֵDUTY21 = 8000x0320PA1˿ڵΪ
            PWMռձ50% = T21R / T21P
*  ע:  ES7P2124
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define PERIOD 1600
#define DUTY21 800
#define DUTY20 400

unsigned int N_Period;
unsigned int N_Duty20;
unsigned int N_Duty21;

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void ram_clear(void)
{
    GIE = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void isr(void) interrupt
{
    if(T21PIE &&T21PIF) 
    {                                   //T20ж
        T21PIF = 0;
        if(N_Period >= 1000)
        {
            N_Period -= 200;
            N_Duty20 -= 50;
            N_Duty21 -= 100;   
            
            T21PH = N_Period>>8;
            T21PL = N_Period;            //PWM
            
            T21R1H = N_Duty21 >> 8;
            T21R1L = N_Duty21;           //PWM
            
            T21R0H = N_Duty20 >> 8;
            T21R0L = N_Duty20;           //PWM
        }
        else
        {
            N_Period = PERIOD;
            N_Duty20 = DUTY20;
            N_Duty21 = DUTY21;
            
            T21PH = N_Period>>8;
            T21PL = N_Period;            //PWM
            
            T21R1H = N_Duty21 >> 8;
            T21R1L = N_Duty21;           //PWM
            
            T21R0H = N_Duty20 >> 8;
            T21R0L = N_Duty20;           //PWM
        }
    }
}

/*********************************************************
:	void main(void) 
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	// RAMʼ
	ram_clear();

	PAS  = 0;
	PAT1 = 0;					//PA1---PWM211 Ϊ	
	PAT2 = 0;					//PA2---PWM210 Ϊ
	PA1  = 0;
	PA2  = 0;

    N_Period = PERIOD;
    N_Duty20 = DUTY20;
	N_Duty21 = DUTY21;

	T21CL = 0xC1;				//T21˫PWMģʽЧ
	T2nOC = 0x0C;				//PWM210,PWM211ʹ

	T21CM = 0;					//T21ԤƵƵ
    T21PH = N_Period >> 8;
    T21PL = N_Period;           //

    T21R1H = N_Duty21 >> 8;
    T21R1L = N_Duty21;          //þ
    T21R0H = N_Duty20 >> 8;    
    T21R0L = N_Duty20;          //þ

    T21CH = 0x80;		        //ʹT21
    T21PIE = 1; 		        //ʹT21ж
    GIE = 1;		            //ʹȫж 
	while (1)
	{	
		__Asm CWDT;	
	}
}
