/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  iic.c
*  :  AE Team
*  :  V1.00	iDesigner(v4.2.3.182) + HRCC(v1.2.0.122)
*  :  2022/01/04
*  :  Bootloaderʾ
		  PA0ģBootPIN
          PB7SCL
          PE0SDA
          I2Cӻͨ ַģʽ7bit ʱƵ100k ӻַ0x2D
		  ʾοӦñʼǡAN102_Ӧñʼ_BootISPλ7PϵMCU Bootloader롶AN112_UserManual_ES-UART-BOOT
*  ע:  ES7P2124
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "iic.h"
#include "systick.h"
#include "isp_proc.h"
#include "macrodef.h"

/***************************************************************
iic_init
  : IICʼ
ֵ
ֵ
ֵ 
***************************************************************/
void iic_init(void)
{
    PET0 = 1;				//SDA˿Ϊ
    PBT7 = 1;				//SCL˿Ϊ
	PES0 = 0;				//PE0ֿ
	PBS7 = 0;				//PB7ֿ
	PSFT2 = 1;

	I2CC = 0xE4;
	I2CSA = SLAVE_ADDR<<1;
	I2CEN = 1;
}

/***************************************************************
iic_stop_proc
  : IICսλ
ֵ
ֵ
ֵ 
***************************************************************/
void iic_stop_proc(void)
{
	while(!I2CSPIF);
	I2CSPIF = 0;
		
	I2CRST = 1;
	while(I2CRST);
	iic_init();
}

/***************************************************************
start_tx
  : I2C
ֵ͵ֽ
ֵ
ֵ 
***************************************************************/
void start_tx(u8 len)
{	
	g_isp_data.tx_cnt = 0;
 	g_isp_data.tx_len = len; 
	I2CTB = g_isp_data.tx_buf[0];
	while(1)
	{
		g_isp_data.tx_cnt++;
		if(g_isp_data.tx_cnt > g_isp_data.tx_len)    //ɣһ
		{
			while(!I2CTBIF);
			g_isp_data.triger = 1;      //״̬һ           
			g_isp_data.rx_cnt = 0;
			break;
		}
		else
		{
			while(!I2CTBIF);
			I2CTB = g_isp_data.tx_buf[g_isp_data.tx_cnt];
		}
	}
	iic_stop_proc();
}

/***************************************************************
iic_proc
  : IIC̴
ֵ
ֵ
ֵ 
***************************************************************/
void iic_proc(void)
{
	iic_stop_proc();
	g_isp_data.tx_buf[0] = ACK;
	start_tx(0);
	g_isp_data.triger = 0;
}

/***************************************************************
IICReceive
  : IIC
ֵ
ֵ
ֵ 
***************************************************************/
void IICReceive(void)
{
	volatile u8 buf8;
	while(1)				//ûнյֱ˳
	{	
		if(I2CRBIF)
		{
			buf8 = I2CRB;
			g_boot_timer = Boot_OVERTIME_2;
			if(g_isp_data.syn)  //ͬɹ
			{
				if((buf8 == SYN) && (g_isp_data.step == WAIT_REV_INS))
				{
					iic_proc();
					break;			
				}
				else
				{					
					if(g_isp_data.step == WAIT_REV_INS)
					{
						g_isp_data.rx_len = 1;
						g_isp_data.rx_cnt = 0;
						g_isp_data.step = IN_REV_INS;  //ڽָ		
					}
					g_isp_data.rx_buf[g_isp_data.rx_cnt] = buf8;
					g_isp_data.rx_cnt++;
					if(g_isp_data.rx_cnt == 2 && g_isp_data.step == WAIT_REV_PARA1 && g_isp_data.cmd == EX_ERASE)
					{
						g_isp_data.rx_len = (g_isp_data.rx_buf[1] + 2) * 2;
					}
					if(g_isp_data.rx_cnt == 1 && g_isp_data.step == WAIT_REV_PARA2 && g_isp_data.cmd == WRITE_M)
					{
						g_isp_data.rx_len = g_isp_data.rx_buf[0] + 2;
					}
					if(g_isp_data.rx_cnt > g_isp_data.rx_len)    //ɣһ
					{
						iic_stop_proc();
						g_isp_data.triger = 1;  //״̬һ
						break;
					}
				}
			}
			else if(buf8 == SYN)  //յͬɹ
			{
				iic_proc();
				g_isp_data.syn = 1;  //ͬ			
				g_isp_data.step = WAIT_REV_INS;
				break;	
			}
		}
		else
		{
			break;
		}
	}
}
