/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    4 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          4 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_rx0_buf[256];
uint32_t g_rx0_len = sizeof(g_rx0_buf);
uint32_t g_rx0_i = 0U;
uint8_t g_first_0 = 0U;

uint8_t g_rx1_buf[256];
uint32_t g_rx1_len = sizeof(g_rx1_buf);
uint32_t g_rx1_i = 0U;
uint8_t g_first_1 = 0U;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  UART IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) CUART2_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_uart_mask_it_tfempty(CUART2))
    {
        if (g_tx0_i < g_tx0_len + g_rx0_i + 1)
        {
            md_uart_set_send_data8(CUART2, g_tx0_buf[g_tx0_i]);
            md_uart_clear_it_tfempty(CUART2);

            g_tx0_i++;
        }
        else
        {
            g_tx0_i = 0;
            g_rx0_i = 0;
            md_uart_disable_it_tfempty(CUART2);
        }
    }

    if (md_uart_mask_it_rfnempty(CUART2))
    {
        if (g_first_0 == 0)
        {
            g_rx0_buf[g_rx0_i] = md_uart_recv_data8(CUART2);
            md_uart_clear_flag_rfnempty(CUART2);

            g_first_0++;
        }
        else
        {
            g_rx0_buf[g_rx0_i] = md_uart_recv_data8(CUART2);
            md_uart_clear_flag_rfnempty(CUART2);

            if ((g_rx0_i >= 1) && (g_rx0_buf[g_rx0_i - 1] == 0x0D) && (g_rx0_buf[g_rx0_i] == 0x0A))
            {
                memcpy(g_tx0_buf + g_tx0_len, g_rx0_buf, g_rx0_i + 1);
                md_uart_enable_it_tfempty(CUART2);
                g_first_0 = 0;
            }
            else
            {
                g_rx0_i++;
            }

            if (g_rx0_i >= g_rx0_len)
                g_rx0_i = 0;
        }
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

void __attribute__((interrupt)) CUART1_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_uart_mask_it_tfempty(CUART1))
    {
        if (g_tx1_i < g_tx1_len + g_rx1_i + 1)
        {
            md_uart_set_send_data8(CUART1, g_tx1_buf[g_tx1_i]);
            md_uart_clear_it_tfempty(CUART1);

            g_tx1_i++;
        }
        else
        {
            g_tx1_i = 0;
            g_rx1_i = 0;
            md_uart_disable_it_tfempty(CUART1);
        }
    }

    if (md_uart_mask_it_rfnempty(CUART1))
    {
        if (g_first_1 == 0)
        {
            g_rx1_buf[g_rx1_i] = md_uart_recv_data8(CUART1);
            md_uart_clear_flag_rfnempty(CUART1);

            g_first_1++;
        }
        else
        {
            g_rx1_buf[g_rx1_i] = md_uart_recv_data8(CUART1);
            md_uart_clear_flag_rfnempty(CUART1);

            if ((g_rx1_i >= 1) && (g_rx1_buf[g_rx1_i - 1] == 0x0D) && (g_rx1_buf[g_rx1_i] == 0x0A))
            {
                memcpy(g_tx1_buf + g_tx1_len, g_rx1_buf, g_rx1_i + 1);
                md_uart_enable_it_tfempty(CUART1);
                g_first_1 = 0;
            }
            else
            {
                g_rx1_i++;
            }

            if (g_rx1_i >= g_rx1_len)
                g_rx1_i = 0;
        }
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
