/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    4 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          4 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
char g_rx_buf[256];
uint32_t g_tx_len;
uint32_t g_tx_i = 0U;
uint32_t g_rx_len = sizeof(g_rx_buf);
uint32_t g_rx_i = 0U;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  UART IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) CUART1_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_uart_mask_it_tfempty(UARTX))
    {
        md_uart_set_send_data8(UARTX, g_rx_buf[g_tx_i]);
        md_uart_clear_it_tfempty(UARTX);

        g_tx_i++;

        if (g_tx_i >= g_tx_len)
        {
            g_tx_i = 0;
            md_uart_disable_it_tfempty(UARTX);
        }
    }

    if (md_uart_mask_it_rfnempty(UARTX))
    {
        g_rx_buf[g_rx_i] = md_uart_recv_data8(UARTX);
        md_uart_clear_flag_rfnempty(UARTX);

        if (g_rx_buf[0] != 0x55) /* if the first byte is not 0x55("U"), re-detect baud. */
        {
            md_uart_set_abrmod(UARTX, 0);
            md_uart_enable_abr(UARTX);

            return;
        }

        if ((g_rx_i >= 1) && (g_rx_buf[g_rx_i - 1] == 0x0D)
                && (g_rx_buf[g_rx_i] == 0x0A))
        {
            g_tx_len = g_rx_i + 1;
            g_rx_i = 0;
            md_uart_enable_it_tfempty(UARTX);
        }
        else
        {
            g_rx_i++;
        }

        if (g_rx_i >= g_rx_len)
            g_rx_i = 0;
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
