/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    26 June 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          26 June 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initialize TOGGLE IO.
  * @param  None
  * @retval None
  */
static void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    /* initialize the HSCO */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_6;
    md_gpio_init(PIS_CH5_PORT, PIS_CH5_PIN, &gpio_init);
}

/**
  * @brief  Initialize PIS.
  * @param  None
  * @retval None
  */
void pis_init(void)
{
    md_pis_init_t pis_init;
    memset(&pis_init, 0, sizeof(md_pis_init_t));

    /* Enable PIS CH5 output */
    md_pis_enable_ch5_output(PIS);

    pis_init.p_src     = MD_PIS_CLK_HSCO;     /* PIS SRC: HSCO */
    pis_init.p_clk     = MD_PIS_CLK_HCLK;
    pis_init.p_edge    = MD_PIS_EDGE_NONE;
    pis_init.p_output  = MD_PIS_OUT_LEVEL;
    pis_init.c_trig    = 0x5;                  /* PIS CH5 output HSCO */
    pis_init.c_clk     = MD_PIS_CLK_HCLK;
    md_pis_init(&pis_init);
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC4M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all(); /* Enable ALL peripheral */
    md_cmu_set_hsco_div(0);   /* 0: HSC / 1 */
    md_cmu_set_hsco_type(4);  /* 4: SYSCLK */
    md_cmu_enable_hsco();     /* Enable HSC output */
    MD_SYSCFG_LOCK();

    __enable_irq();

    pis_init();

    /* Initialize the gpio */
    init_gpio();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
