/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    5 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "md_conf.h"
/* Exported Macros ----------------------------------------------------------- */
#define I2C_SCL_PORT   GPIOB
#define I2C_SCL_PIN    MD_GPIO_PIN_2      /* I2CSCL */
#define I2C_SDA_PORT   GPIOB
#define I2C_SDA_PIN    MD_GPIO_PIN_3      /* I2CSDA */

#define I2CX I2C0

#define I2C_REQUEST_WRITE   0
#define I2C_REQUEST_READ    1

#define SLAVE_ADDR   0x2D

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern md_i2c_init_t g_md_i2c;
extern uint8_t g_recv_buf[20];
extern uint8_t g_recv_len;
extern uint8_t g_recv_inc;
extern uint8_t g_send_buf[20];
extern uint8_t g_send_len;
extern uint8_t g_send_inc;
extern uint8_t g_complete;
extern uint8_t g_error_flag;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
