/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    3 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_recv_buf[20] = {0U};
uint8_t g_send_buf[20] = {0U};
uint8_t g_dir_flag = 0U;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  Init UART pin
  * @retval None
  */
void uart_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize tx pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(UART_TX_PORT, UART_TX_PIN, &gpio_init);

    /* Initialize rx pin */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(UART_RX_PORT, UART_RX_PIN, &gpio_init);
}

/**
  * @brief:  Initialize the uart.
  * @param:  None
  * @retval: None
  */
void uart_init(void)
{
    md_uart_init_t uart_init;
    md_uart_init_struct(&uart_init);

    /* Initialize UART */
    uart_init.baud        = 115200;
    uart_init.word_length = MD_UART_WORD_LENGTH_8B;
    uart_init.stop_bits   = MD_UART_STOP_BITS_1;
    uart_init.parity      = MD_UART_PARITY_NONE;
    uart_init.fctl        = MD_UART_FLOW_CTL_DISABLE;
    uart_init.mode        = MD_UART_MODE;
    md_uart_init(UARTX, &uart_init);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    md_dma_config_t dma_config;

    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    uart_pin_init();

    uart_init();

    memset(&dma_config, 0x0, sizeof(md_dma_config_t));
    dma_config.src            = (void *)&UARTX->RXBUF;
    dma_config.dst            = g_recv_buf;
    dma_config.size           = sizeof(g_recv_buf);
    dma_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_config.src_inc        = DISABLE;
    dma_config.dst_inc        = ENABLE;
    dma_config.R_power        = MD_DMA_R_POWER_1;
    dma_config.priority       = MD_DMA_HIGHEST_PRIORITY;
    dma_config.mem_to_mem     = DISABLE;
    dma_config.circle_mode    = DISABLE;
    dma_config.msel           = MD_DMA_MSEL_CUART1;
    dma_config.msigsel        = MD_DMA_MSIGSEL_UART_RNR;
    md_dma_clear_flag_tc(MD_DMA_CH_0);
    md_dma_init(MD_DMA_CH_0, &dma_config);
    md_dma_enable_channel(MD_DMA_CH_0);
    md_uart_enable_rxdma(UARTX);

    while (1)
    {
        if (!g_dir_flag && !md_uart_is_active_flag_rsbusy(UARTX) && md_dma_is_active_rif_tc(MD_DMA_CH_0))
        {
            md_dma_clear_flag_tc(MD_DMA_CH_0);
            g_dir_flag = 1;

            md_uart_disable_rxdma(UARTX);
            md_uart_disable_txdma(UARTX);

            memcpy(g_send_buf, g_recv_buf, sizeof(g_send_buf));

            memset(&dma_config, 0x0, sizeof(md_dma_config_t));
            dma_config.src            = g_send_buf;
            dma_config.dst            = (void *)&UARTX->TXBUF;
            dma_config.size           = sizeof(g_send_buf);
            dma_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
            dma_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
            dma_config.src_inc        = ENABLE;
            dma_config.dst_inc        = DISABLE;
            dma_config.R_power        = MD_DMA_R_POWER_1;
            dma_config.priority       = MD_DMA_HIGHEST_PRIORITY;
            dma_config.mem_to_mem     = DISABLE;
            dma_config.circle_mode    = DISABLE;
            dma_config.msel           = MD_DMA_MSEL_CUART1;
            dma_config.msigsel        = MD_DMA_MSIGSEL_UART_TXEMPTY;
            md_dma_init(MD_DMA_CH_0, &dma_config);
            md_dma_enable_channel(MD_DMA_CH_0);

            md_uart_clear_it_tfempty(UARTX);
            md_uart_enable_txdma(UARTX);
        }

        if (g_dir_flag && !md_uart_is_active_flag_tsbusy(UARTX) && md_dma_is_active_rif_tc(MD_DMA_CH_0))
        {
            md_dma_clear_flag_tc(MD_DMA_CH_0);
            g_dir_flag = 0;

            md_uart_disable_txdma(UARTX);
            md_uart_disable_rxdma(UARTX);

            memset(&dma_config, 0x0, sizeof(md_dma_config_t));
            dma_config.src            = (void *)&UARTX->RXBUF;
            dma_config.dst            = g_recv_buf;
            dma_config.size           = sizeof(g_recv_buf);
            dma_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
            dma_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
            dma_config.src_inc        = DISABLE;
            dma_config.dst_inc        = ENABLE;
            dma_config.R_power        = MD_DMA_R_POWER_1;
            dma_config.priority       = MD_DMA_HIGHEST_PRIORITY;
            dma_config.mem_to_mem     = DISABLE;
            dma_config.circle_mode    = DISABLE;
            dma_config.msel           = MD_DMA_MSEL_CUART1;
            dma_config.msigsel        = MD_DMA_MSIGSEL_UART_RNR;
            md_dma_init(MD_DMA_CH_0, &dma_config);
            md_dma_enable_channel(MD_DMA_CH_0);

            md_uart_clear_flag_rfnempty(UARTX);
            md_uart_enable_rxdma(UARTX);
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
