/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    16 June 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          16 June 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "md_conf.h"

/* Exported Macros ----------------------------------------------------------- */
#define HRC4MCALN                  *(volatile uint32_t *)0x40083C10
#define ADCFREQC1                  *(volatile uint16_t *)0x40900
#define ADCFREQC4                  *(volatile uint16_t *)0x40904
#define ADCTEMPC1                  *(volatile uint16_t *)0x40908
#define ADCTEMPC4                  *(volatile uint16_t *)0x4090C
#define HRC4MFT                    *(volatile uint16_t *)0x40BE8
#define HRC4MCALO                  *(volatile uint16_t *)0x40848
#define SYSCFG1_PROT               *(volatile uint32_t *)0x40080100

#define ADCREFP 3300  /* Actual reference voltage, unit mV, error not more than ±2% */

#define HSCO_PORT GPIOA
#define HSCO_PIN  MD_GPIO_PIN_8

#define LED_PORT GPIOA
#define LED_PIN  MD_GPIO_PIN_15

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_temp;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
