/**********************************************************************************
 *
 * @file    smart_card.h
 * @brief   smart_card h File.
 *
 * @date    17 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/** @addtogroup UART_Application
  * @{
  */

/** @defgroup Smart_card Smart_card
  * @brief usart application demo for smart card
  * @{
  */

#ifndef __SMART_CARD__
#define __SMART_CARD__

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define CARD_OK     0x00
#define CARD_ERROR  0x01

/* Exported Variables -------------------------------------------------------- */

extern uint8_t g_tx_buf[32];
extern uint8_t g_tx_len;
extern uint8_t g_tx_i;
extern uint8_t g_rx_buf[32];
extern uint8_t g_rx_len;
extern uint8_t g_rx_i;

extern ald_uart_handle_t g_h_uart;

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

uint8_t reset_rec(uint8_t *rxbuf);
uint8_t instruction_test(void);
uint8_t rand_instruction_test(void);
uint8_t name_instruction_test(void);

#endif /* __SMART_CARD__ */

/**
  * @}Smart_card
  */

/**
  * @}Micro_Driver
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
