/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    14 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          14 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ------------------------------------------------------------------ */

#include "ald_utils.h"
#include "ald_spi.h"
#include "ald_gpio.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define SPI_NSS_PORT  GPIOA
#define SPI_NSS_PIN   ALD_GPIO_PIN_4
#define SPI_SCK_PORT  GPIOA
#define SPI_SCK_PIN   ALD_GPIO_PIN_5
#define SPI_MISO_PORT GPIOA
#define SPI_MISO_PIN  ALD_GPIO_PIN_6
#define SPI_MOSI_PORT GPIOA
#define SPI_MOSI_PIN  ALD_GPIO_PIN_7

#define FLASH_CS_SET() (ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 1))
#define FLASH_CS_CLR() (ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 0))

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

ald_status_t flash_sector_erase(uint32_t addr);
ald_status_t flash_write(uint32_t addr, char *buf, uint16_t size);
ald_status_t flash_read(uint32_t addr, char *buf, uint16_t size);
ald_status_t flash_wait_unbusy(void);
uint32_t flash_read_id(void);
void init_mcu_spi(void);

#endif    /*__FLASH_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
