/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    16 Feb. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          16 Feb. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  EXTI2 IRQ handler
  * @retval None
  */
void exti2_irq_handler(void)
{
    /* exti2 interrupt */
    if (ald_gpio_exti_get_ie_status(KEY_PIN) && ald_gpio_exti_get_flag_status(KEY_PIN))
    {
        ald_gpio_exti_clear_flag_status(KEY_PIN);  /* clear exit2 interrupt flag */
        ald_gpio_toggle_pin(LED_PORT, LED_PIN);    /* toggle LED pin */
    }

    return;

}
/**
  * @brief  Initializate pin.
  * @retval None
  */
void init_gpio(void)
{
    ald_gpio_init_t gpio_init;

    /* Initialize LED pin */
    memset(&gpio_init, 0x0, sizeof(gpio_init)); /* initialize the gpio_init */
    gpio_init.mode = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od   = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd = ALD_GPIO_FLOATING;
    gpio_init.func = ALD_GPIO_FUNC_1;
    gpio_init.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    ald_gpio_init(LED_PORT, LED_PIN, &gpio_init);

    /* Initialize KEY pin */
    memset(&gpio_init, 0x0, sizeof(gpio_init)); /* initialize the gpio_init */
    gpio_init.mode = ALD_GPIO_MODE_INPUT;
    gpio_init.pupd = ALD_GPIO_FLOATING;
    gpio_init.flt  = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type = ALD_GPIO_TYPE_CMOS;
    gpio_init.func = ALD_GPIO_FUNC_1;
    gpio_init.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    ald_gpio_init(KEY_PORT, KEY_PIN, &gpio_init);

    return;
}

/**
  * @brief  Initializate exit.
  * @retval None
  */
void init_exti(void)
{
    ald_exti_init_t exti;
    /* Initialize external interrupt */
    exti.filter      = ENABLE;
    exti.filter_time = 10;
    ald_gpio_exti_init(KEY_PORT, KEY_PIN, &exti);

    /* Configure interrupt */
    ald_gpio_exti_interrupt_config(KEY_PIN, ALD_EXTI_TRIGGER_RISING_EDGE, ENABLE);
    /* Clear interrupt flag */
    ald_gpio_exti_clear_flag_status(KEY_PIN);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    init_gpio();

    /* Initialize exti */
    init_exti();

    /* Enable external interrupt */
    ald_mcu_irq_config(EXTI0_3_IRQn, 4, ENABLE);
    __enable_irq();

    while (1)
    {
        ald_delay_1ms(10);
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
