/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    07 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
ald_crc_handle_t g_h_crc;
unsigned int g_result = 0U;
ald_status_t g_state = ALD_ERROR;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */
void uart_init(void);

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  calculate completed callback.
  * @param  arg: Pointer to crc_handle_t structure.
  * @retval None.
  */
void calculate_complete(ald_crc_handle_t *arg)
{
    return;
}

/**
  * @brief  calculate error callback.
  * @param  arg: Pointer to crc_handle_t structure.
  * @retval None.
  */
void error_complete(ald_crc_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint8_t crc_buf[8] = {1U, 2U, 3U, 4U, 5U, 6U, 7U, 8U};

    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);

    /* Enable all peripherals */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    __enable_irq();

    uart_init();
    printf("CRC demo\r\n");

    /* Clear crc_handle_t structure */
    memset(&g_h_crc, 0x0, sizeof(ald_crc_handle_t));

    /* Initialize CRC */
    g_h_crc.perh = CRC;
    g_h_crc.init.mode = ALD_CRC_MODE_32;
    g_h_crc.init.seed = 0xFFFFFFFF;
    g_h_crc.init.data_rev = ENABLE;
    g_h_crc.init.data_inv = DISABLE;
    g_h_crc.init.chs_rev = ENABLE;
    g_h_crc.init.chs_inv = ENABLE;
    g_h_crc.cal_cplt_cbk = calculate_complete;
    g_h_crc.err_cplt_cbk = error_complete;
    ald_crc_init(&g_h_crc);

    /* start calculate and g_result is 0x3FCA88C5 */
    g_result = ald_crc_calculate(&g_h_crc, crc_buf, sizeof(crc_buf));
    printf("CRC-32 g_result: 0x%08X\r\n", g_result);/* Init CRC */

    /* Initialize CRC */
    g_h_crc.perh = CRC;
    g_h_crc.init.mode = ALD_CRC_MODE_32;
    g_h_crc.init.seed = 0xFFFFFFFF;
    g_h_crc.init.data_rev = DISABLE;
    g_h_crc.init.data_inv = DISABLE;
    g_h_crc.init.chs_rev = DISABLE;
    g_h_crc.init.chs_inv = DISABLE;
    g_h_crc.cal_cplt_cbk = calculate_complete;
    g_h_crc.err_cplt_cbk = error_complete;
    ald_crc_init(&g_h_crc);

    /* start calculate and g_result is 0x140B8DD8*/
    g_result = ald_crc_calculate(&g_h_crc, crc_buf, sizeof(crc_buf));
    printf("CRC-32/MPEG-2 g_result: 0x%08X\r\n", g_result);
    printf("\r\n");

    while (1)
    {
        ald_delay_1ms(1000);
    }
}

void uart_gpio_init(void)
{
    ald_gpio_init_t gpio_init;
    memset(&gpio_init, 0x00, sizeof(ald_gpio_init_t));

    /* Initialize tx pin: PA2 */
    gpio_init.mode = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od   = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd = ALD_GPIO_PUSH_UP;
    gpio_init.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt  = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type = ALD_GPIO_TYPE_CMOS;
    gpio_init.func = ALD_GPIO_FUNC_2;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &gpio_init);

    return;
}

ald_uart_handle_t g_h_uart = {0};
void uart_init(void)
{
    uart_gpio_init();

    g_h_uart.perh             = UARTX;
    g_h_uart.init.baud        = 115200;
    g_h_uart.init.word_length = ALD_UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits   = ALD_UART_STOP_BITS_1;
    g_h_uart.init.parity      = ALD_UART_PARITY_NONE;
    g_h_uart.init.mode        = ALD_UART_MODE_UART;
    g_h_uart.init.fctl        = ALD_UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_h_uart);
}

int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        cnt = 4000;

        while (!ald_uart_get_status(&g_h_uart, ALD_UART_STATUS_TFEMPTY) && (--cnt));

        g_h_uart.perh->TXBUF = *ptr_char++;
    }

    return len;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
