/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    16 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          16 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
ald_adc_handle_t g_adc_config;
ald_adc_nch_conf_t g_nch_config;
uint16_t g_vdd_val = 0U;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  Adc normal convert complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void normal_convert_complete(ald_adc_handle_t *arg)
{
    g_vdd_val = VREF * 4095 / ald_adc_normal_get_value(&g_adc_config);

    return;
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_clock_config(ALD_CMU_CLOCK_HRC48M, 48000000);

    /* Enable ALL peripheral */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    ald_mcu_irq_config(ADC_IRQn, 4, ENABLE);
    __enable_irq();

    memset(&g_adc_config, 0x0, sizeof(ald_adc_handle_t));
    memset(&g_nch_config, 0x0, sizeof(ald_adc_nch_conf_t));

    /* Initialize adc */
    g_adc_config.perh            = ADC;
    g_adc_config.init.align      = ALD_ADC_DATAALIGN_RIGHT;
    g_adc_config.init.scan       = ENABLE;
    g_adc_config.init.cont       = ENABLE;
    g_adc_config.init.disc       = ALD_ADC_ALL_DISABLE;
    g_adc_config.init.disc_nr    = ALD_ADC_DISC_NR_1;
    g_adc_config.init.data_bit   = ALD_ADC_CONV_BIT_12;
    g_adc_config.init.div        = ALD_ADC_CKDIV_128;
    g_adc_config.init.nche_sel   = ALD_ADC_NCHESEL_MODE_ALL;
    g_adc_config.init.nch_nr     = ALD_ADC_NCH_NR_1;
    g_adc_config.init.n_ref      = ALD_ADC_NEG_REF_VSS;
    g_adc_config.init.p_ref      = ALD_ADC_POS_REF_VDD;
    g_adc_config.normal_cplt_cbk = normal_convert_complete;
    ALD_ADC_ENABLE(&g_adc_config);
    ALD_ADC_DISABLE(&g_adc_config);
    ald_adc_init(&g_adc_config);

    /* Initialize normal convert channel */
    g_nch_config.ch   = ALD_ADC_CHANNEL_19;
    g_nch_config.idx  = ALD_ADC_NCH_IDX_1;
    g_nch_config.samp = ALD_ADC_SAMPLETIME_18;
    ald_adc_normal_channel_config(&g_adc_config, &g_nch_config);

    /* Start normal convert, enable interrupt */
    ald_adc_normal_start_by_it(&g_adc_config);

    while (1)
    {
        ald_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
