/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    16 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          16 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "ald_conf.h"

/* Exported Macros ----------------------------------------------------------- */
#define ADC_CHANNEL4_PIN  ALD_GPIO_PIN_4
#define ADC_CHANNEL4_PORT GPIOC
#define ADC_CHANNEL5_PIN  ALD_GPIO_PIN_5
#define ADC_CHANNEL5_PORT GPIOA
#define ADC_CHANNEL6_PIN  ALD_GPIO_PIN_6
#define ADC_CHANNEL6_PORT GPIOA
#define ADC_CHANNEL7_PIN  ALD_GPIO_PIN_7
#define ADC_CHANNEL7_PORT GPIOA

#define VDD 3300 /* 根据实际VDD值变化，单位：mV */

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern ald_adc_handle_t g_adc_config;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
