/*
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2018-08-24     yangjie      the first version
 * 2024-01-17     shiwa        update comments
 */

/* 程序清单：关闭中断进行全局变量的访问 */
/* Includes ------------------------------------------------------------------ */
#include <rthw.h>
#include <rtthread.h>

/* Private Macros ------------------------------------------------------------ */
#define THREAD_PRIORITY      5
#define THREAD_STACK_SIZE    512
#define THREAD_TIMESLICE     5

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */
/* 同时访问的全局变量 */
static rt_uint32_t s_cnt;

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
void thread_entry(void *parameter)
{
    rt_uint32_t no;
    rt_uint32_t level;

    no = (rt_uint32_t) parameter;

    while (1)
    {
        /* 关闭中断 */
        level = rt_hw_interrupt_disable();
        s_cnt += no;
        /* 恢复中断 */
        rt_hw_interrupt_enable(level);

        rt_kprintf("[%d]CNT=%d\n", no, s_cnt);
        rt_thread_mdelay(no * 10);
    }
}

int interrupt_sample(void)
{
    rt_thread_t thread;

    /* 创建thread1线程 */
    thread = rt_thread_create("thread1", thread_entry, (void *)10,
                              THREAD_STACK_SIZE,
                              THREAD_PRIORITY, THREAD_TIMESLICE);

    if (thread != RT_NULL)
        rt_thread_startup(thread);

    /* 创建thread2线程 */
    thread = rt_thread_create("thread2", thread_entry, (void *)20,
                              THREAD_STACK_SIZE,
                              THREAD_PRIORITY, THREAD_TIMESLICE);

    if (thread != RT_NULL)
        rt_thread_startup(thread);

    return 0;
}


