// SquareLine LVGL GENERATED FILE
// EDITOR VERSION: SquareLine Studio 1.1.0
// LVGL VERSION: 8.2
// PROJECT: SquareLine_Project

#include "ui.h"

#define ES_SPINNER1_ARC_LENGTH  (90)     
#define ES_SPINNER1_PERIOD      (1000)

LV_IMG_DECLARE(g_img_demo_gif);    
                            
static lv_obj_t * s_es_temp_gif1 = NULL;
static lv_obj_t * s_es_temp_obj1 = NULL; 
static lv_obj_t * s_es_temp_obj1_roller1 = NULL;  
static lv_obj_t * s_es_temp_obj1_roller2 = NULL; 
static lv_obj_t * s_es_temp_obj1_roller3 = NULL; 
static lv_obj_t * s_es_temp_obj1_btn_sure = NULL;
static lv_obj_t * s_es_temp_obj1_btn_back = NULL; 
static lv_obj_t * s_es_temp_obj1_btn_sure_label = NULL;
static lv_obj_t * s_es_temp_obj1_btn_back_label = NULL;
                       

static int32_t s_counter = 0;      
static uint8_t s_rgb565_r = 0U;
static uint8_t s_rgb565_g = 0U;
static uint8_t s_rgb565_b = 0U;
static uint32_t s_time_value = 0U;
static char s_time_buf9[9];

static const char * s_string_0_23 = "00\n01\n02\n03\n04\n05\n06\n07\n08\n09\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n20\n21\n22\n23"; 
static const char * s_string_0_59 = "00\n01\n02\n03\n04\n05\n06\n07\n08\n09\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n20\n21\n22\n23\n24\n25\n26\n27\n28\n29\n30\n31\n32\n33\n34\n35\n36\n37\n38\n39\n40\n41\n42\n43\n44\n45\n46\n47\n48\n49\n50\n51\n52\n53\n54\n55\n56\n57\n58\n59";

void es_set_show_timelabel(void)
{
    if(s_time_value >= 86400)
        while(1);
    
    if(lv_obj_is_valid(ui_Label1time))
        {
            s_time_buf9[0] = '0' + ((s_time_value)/36000);  
            s_time_buf9[1] = '0' + (((s_time_value)/3600)%10);  
            s_time_buf9[2] = ' ';                 
            s_time_buf9[3] = '0' + (((s_time_value)%3600)/600); 
            s_time_buf9[4] = '0' + (((s_time_value)/60)%10);                
            s_time_buf9[5] = ' ';                         
            s_time_buf9[6] = '0' + ((s_time_value%60)/10); 
            s_time_buf9[7] = '0' + ((s_time_value)%10);
            s_time_buf9[8] = '\0';
            
            lv_label_set_text(ui_Label1time,s_time_buf9); 
        }
}

void es_example_lv_time_callback1(void)
{
    static uint32_t last_ms = 0U;
    uint32_t now_ms;
    
    now_ms = lv_tick_get();
    
    if((now_ms||last_ms)&&(now_ms!=last_ms)&&((now_ms - last_ms) >= 1000))
    {
        last_ms += 1000;
        
        s_time_value = (s_time_value + 1)%(86400);
        es_set_show_timelabel();
    }
}
         
void s_es_temp_obj1_btn_back_label_event_handler(lv_event_t * e)
{  
        if(lv_obj_is_valid(s_es_temp_obj1))
        {
            lv_obj_add_flag(s_es_temp_obj1, LV_OBJ_FLAG_HIDDEN);
        } 
}

void s_es_temp_obj1_btn_sure_label_event_handler(lv_event_t * e)
{      
        s_time_value = ((lv_roller_get_selected(s_es_temp_obj1_roller1))*3600) + 
                       ((lv_roller_get_selected(s_es_temp_obj1_roller2))*60) + 
                       (lv_roller_get_selected(s_es_temp_obj1_roller3));
        es_set_show_timelabel();
        
        s_es_temp_obj1_btn_back_label_event_handler(e);
}

void es_lv_try_objs_temp()
{ 
    if(lv_obj_is_valid(ui_Screen4))
    { 
        if(!(lv_obj_is_valid(s_es_temp_obj1)))
        {
            s_es_temp_obj1 = lv_obj_create(ui_Screen4);
            lv_obj_align(s_es_temp_obj1, LV_ALIGN_CENTER, 0, 20);
            lv_obj_set_size(s_es_temp_obj1, 280, 180);
            lv_obj_set_style_bg_opa(s_es_temp_obj1, 128, LV_PART_MAIN | LV_STATE_DEFAULT);
                
            s_es_temp_obj1_btn_sure = lv_btn_create(s_es_temp_obj1);     
            lv_obj_set_align(s_es_temp_obj1_btn_sure, LV_ALIGN_TOP_LEFT);
            lv_obj_set_size(s_es_temp_obj1_btn_sure, 40, 40);                                        
            lv_obj_add_event_cb(s_es_temp_obj1_btn_sure, s_es_temp_obj1_btn_sure_label_event_handler, LV_EVENT_CLICKED, NULL); 
        
            s_es_temp_obj1_btn_back = lv_btn_create(s_es_temp_obj1); 
            lv_obj_set_align(s_es_temp_obj1_btn_back, LV_ALIGN_TOP_RIGHT);
            lv_obj_set_size(s_es_temp_obj1_btn_back, 40, 40);                                                   
            lv_obj_add_event_cb(s_es_temp_obj1_btn_back, s_es_temp_obj1_btn_back_label_event_handler, LV_EVENT_CLICKED, NULL);  
        
            s_es_temp_obj1_btn_sure_label = lv_label_create(s_es_temp_obj1_btn_sure);  
            lv_obj_set_align(s_es_temp_obj1_btn_sure_label, LV_ALIGN_CENTER);
            lv_obj_set_style_text_font(s_es_temp_obj1_btn_sure_label, &lv_font_montserrat_14, LV_PART_MAIN | LV_STATE_DEFAULT);          
            lv_label_set_text(s_es_temp_obj1_btn_sure_label, LV_SYMBOL_OK);            
                        
            s_es_temp_obj1_btn_back_label = lv_label_create(s_es_temp_obj1_btn_back);  
            lv_obj_set_align(s_es_temp_obj1_btn_back_label, LV_ALIGN_CENTER);
            lv_obj_set_style_text_font(s_es_temp_obj1_btn_back_label, &lv_font_montserrat_14, LV_PART_MAIN | LV_STATE_DEFAULT);          
            lv_label_set_text(s_es_temp_obj1_btn_back_label, LV_SYMBOL_CLOSE);         
                                                                      
            s_es_temp_obj1_roller1 = lv_roller_create(s_es_temp_obj1);
            lv_roller_set_options(s_es_temp_obj1_roller1,s_string_0_23,LV_ROLLER_MODE_NORMAL);
            lv_roller_set_visible_row_count(s_es_temp_obj1_roller1, 3);
            lv_obj_set_width(s_es_temp_obj1_roller1, 80);
            lv_obj_set_align(s_es_temp_obj1_roller1,LV_ALIGN_BOTTOM_LEFT);        
            lv_obj_set_style_bg_opa(s_es_temp_obj1_roller1, 128, LV_PART_ANY | LV_STATE_DEFAULT);
                     
            s_es_temp_obj1_roller2 = lv_roller_create(s_es_temp_obj1);
            lv_roller_set_options(s_es_temp_obj1_roller2,s_string_0_59,LV_ROLLER_MODE_NORMAL);
            lv_roller_set_visible_row_count(s_es_temp_obj1_roller2, 3);                
            lv_obj_set_width(s_es_temp_obj1_roller2, 80);
            lv_obj_set_align(s_es_temp_obj1_roller2,LV_ALIGN_BOTTOM_MID);           
            lv_obj_set_style_bg_opa(s_es_temp_obj1_roller2, 128, LV_PART_ANY | LV_STATE_DEFAULT);
                          
            s_es_temp_obj1_roller3 = lv_roller_create(s_es_temp_obj1);
            lv_roller_set_options(s_es_temp_obj1_roller3,s_string_0_59,LV_ROLLER_MODE_NORMAL);
            lv_roller_set_visible_row_count(s_es_temp_obj1_roller3, 3);   
            lv_obj_set_width(s_es_temp_obj1_roller3, 80);
            lv_obj_set_align(s_es_temp_obj1_roller3,LV_ALIGN_BOTTOM_RIGHT);           
            lv_obj_set_style_bg_opa(s_es_temp_obj1_roller3, 128, LV_PART_ANY | LV_STATE_DEFAULT);
        }
        
        lv_obj_clear_flag(s_es_temp_obj1, LV_OBJ_FLAG_HIDDEN);
    }
}


/*参考lv_spinner.c*/
static void arc_anim_start_angle(void * obj, int32_t v)
{
    lv_arc_set_start_angle(obj, (uint16_t) v);
}

/*参考lv_spinner.c*/
static void arc_anim_end_angle(void * obj, int32_t v)
{
    lv_arc_set_end_angle(obj, (uint16_t) v);
}

/*参考lv_spinner.c*/
static void es_spinner_anim_set(uint8_t dir, lv_obj_t * obj)
{
    lv_obj_clear_flag(obj, LV_OBJ_FLAG_CLICKABLE);
    
    lv_anim_del(obj, NULL);

    lv_anim_t a;
    lv_anim_init(&a);
    lv_anim_set_var(&a, obj);
    lv_anim_set_exec_cb(&a, arc_anim_end_angle);
    lv_anim_set_repeat_count(&a, LV_ANIM_REPEAT_INFINITE);
    lv_anim_set_time(&a, ES_SPINNER1_PERIOD);
    if(dir)
        lv_anim_set_values(&a, ES_SPINNER1_ARC_LENGTH, 360 + ES_SPINNER1_ARC_LENGTH);
    else
        lv_anim_set_values(&a, 360 + ES_SPINNER1_ARC_LENGTH, ES_SPINNER1_ARC_LENGTH);
    lv_anim_start(&a);

    lv_anim_set_path_cb(&a, lv_anim_path_ease_in_out);
    if(dir)
        lv_anim_set_values(&a, 0, 360);
    else
        lv_anim_set_values(&a, 360, 0);
    lv_anim_set_exec_cb(&a, arc_anim_start_angle);
    lv_anim_start(&a);

    lv_arc_set_bg_angles(obj, 0, 360);
    lv_arc_set_rotation(obj, 270);
}

void es_init_screen_conuter(lv_event_t * e)
{
    lv_label_set_text_fmt(ui_Label1counter, "%d", s_counter);
}

void es_init_screen_slider(lv_event_t * e)
{

}

void es_init_screen_input(lv_event_t * e)
{

}

void es_init_screen_anim(lv_event_t * e)
{
    if((!(lv_obj_is_valid(s_es_temp_gif1)))&&(lv_obj_is_valid(ui_Screen5)))
    {
        s_es_temp_gif1 = lv_gif_create(ui_Screen5);
        lv_gif_set_src(s_es_temp_gif1, &g_img_demo_gif);
        lv_obj_align(s_es_temp_gif1, LV_ALIGN_CENTER, 120, -60);
    }
}

void es_init_screen_list(lv_event_t * e)
{
    
}

void es_conutor_plus(lv_event_t * e)
{     
        s_counter++;
        lv_label_set_text_fmt(ui_Label1counter, "%d", s_counter);
}

void es_conuter_minus(lv_event_t * e)
{
        s_counter--;
        lv_label_set_text_fmt(ui_Label1counter, "%d", s_counter);
}
 
void es_color_change(lv_event_t * e)
{
        uint16_t slider_red_value   =(uint16_t)(lv_slider_get_value(ui_Slider1red)); 
        uint16_t slider_green_value =(uint16_t)(lv_slider_get_value(ui_Slider1green));
        uint16_t slider_blue_value  =(uint16_t)(lv_slider_get_value(ui_Slider1blue));
    
        s_rgb565_r = (((slider_red_value * 31)/100))&0x1F;
        s_rgb565_g = (((slider_green_value * 63)/100))&0x3F;
        s_rgb565_b = (((slider_blue_value * 31)/100))&0x1F;
                                                                                   
        lv_label_set_text_fmt(ui_Label1red, "红: %2d/31",s_rgb565_r);   
        lv_label_set_text_fmt(ui_Label1green, "绿: %2d/63",s_rgb565_g);
        lv_label_set_text_fmt(ui_Label1blue, "蓝: %2d/31",s_rgb565_b);
    
        lv_obj_set_style_bg_color(ui_Panel1color, lv_color_hex(((uint32_t)s_rgb565_r << 19)|(s_rgb565_g << 10)|(s_rgb565_b << 3)), LV_PART_MAIN | LV_STATE_DEFAULT);
}

void es_checkbox_state_change(lv_event_t * e)
{
        if((lv_obj_get_state(ui_Checkbox1changed) & LV_STATE_CHECKED))
        {
            es_spinner_anim_set(1,ui_Spinner1changed);
            lv_bar_set_value(ui_Bar1changed,(lv_bar_get_max_value(ui_Bar1changed)),LV_ANIM_ON);
            lv_checkbox_set_text(ui_Checkbox1changed, "开启中");
        }
        else
        {
            es_spinner_anim_set(0,ui_Spinner1changed);
            lv_bar_set_value(ui_Bar1changed,(lv_bar_get_min_value(ui_Bar1changed)),LV_ANIM_ON);
            lv_checkbox_set_text(ui_Checkbox1changed, "关闭中");
        }
}

void es_set_time1(lv_event_t * e)
{
	es_lv_try_objs_temp();
}
