/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

#define LCD_SIZE   (160 * 128)
#define EACH_LCD_BUF_SIZE   (160 << 6)

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

extern const uint32_t pictrues_info[][4];
uint16_t g_lcd_buf1[EACH_LCD_BUF_SIZE];

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

extern void es_tst_st7789_write_area(uint16_t x1, uint16_t x2, uint16_t y1,uint16_t y2, uint16_t *color_p);

/* Private Function ---------------------------------------------------------- */

void _putchar(char character)
{
    while ((READ_BIT(CUART1->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK)
    {
    }

    md_uart_set_send_data8(CUART1, character);
}

void tst_lcd_all_color(uint16_t color)
{
	uint32_t i;
	
		for(i = 0;i < EACH_LCD_BUF_SIZE;i++)
			g_lcd_buf1[i] = color;
			
		es_tst_st7789_write_area(2,129, 1, 80, g_lcd_buf1);
		es_tst_st7789_write_area(2,129, 81, 160, g_lcd_buf1);	
}

int main(void)
{
	uint32_t key_time,index,read_size,addr;
	uint16_t key_status,key_status_last;
	uint8_t img_index;
	
    /*初始化芯片*/
    es_mcu_init();
	
	key_time = 0;
	key_status = 0;
	key_status_last = 0;

	img_index = 0;
	index = 0;
	tst_lcd_all_color(0);
    md_gpio_set_pin_high(ES_LCD_BL_PIN_PORT, ES_LCD_BL_PIN_MD_PIN);
			
    while (1)
    {
		key_status = (GPIOD->DIN) & MD_GPIO_PIN_2;
		if(key_status != key_status_last)
		{
			if(((md_get_tick()) - key_time) > 100)
			{
				if(key_status == 0)
				{
					img_index = (img_index + 1)%3;
					index = 0;
					
					if(img_index == 1)
						tst_lcd_all_color(11538);
					else
						tst_lcd_all_color(0);
				}
			}
			
			key_status_last = key_status;
			key_time = md_get_tick();
		}
		
		if(img_index == 0)
		{
			index = (index + 1) % 29;
		}
		
		if(img_index == 1)
		{
			index = 30 + (index - 30 + 1) % 123;
		}
		
		if(img_index == 2)
		{
			index = 155 + (index - 155 + 1) % 72;
		}
		
		addr = pictrues_info[index][1] * 2;
		read_size = pictrues_info[index][2] * 80 * 2;
		
		ll_flash_sector_read((uint8_t *)g_lcd_buf1, addr , read_size);
		es_tst_st7789_write_area(1, pictrues_info[index][2], 1, 80, g_lcd_buf1);
		
		addr += read_size;
		read_size = (pictrues_info[index][3] - 80) * pictrues_info[index][2] * 2;
		
		ll_flash_sector_read((uint8_t *)g_lcd_buf1,addr , read_size);
		es_tst_st7789_write_area(1, pictrues_info[index][2], 81, pictrues_info[index][3], g_lcd_buf1);
    }
}
