/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "stdio.h"
#include "printf.h"
#include "ui.h"

/* Private Macros ------------------------------------------------------------ */
#define printf printf_/*Reduce ROM usage*/
#define ES_LVGL_IMG_FILE_MEM_USE_MALLOC  0

/* Private Variables --------------------------------------------------------- */
static lv_disp_draw_buf_t s_draw_buf_dsc;
static lv_color_t s_draw_buf_1[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*A buffer for n rows*/
#if (ES_LVGL_USE_2_DISP_BUF)
    static lv_color_t s_draw_buf_2[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*An other buffer for n rows*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/
static lv_disp_drv_t s_es_disp_drv;                    /*Descriptor of a display driver*/
static lv_indev_drv_t s_indev_drv;
static lv_fs_drv_t s_es_lv_fs_drv;
static lv_coord_t s_indev_x = 0;
static lv_coord_t s_indev_y = 0;
static lv_indev_state_t s_indev_state = LV_INDEV_STATE_RELEASED;
#if (ES_LVGL_IMG_FILE_MEM_USE_MALLOC == 0)
    static uint32_t s_es_img_file_read_index[ES_EXTERN_IMG_NUM];
#endif /*(ES_LVGL_IMG_FILE_MEM_USE_MALLOC == 0)*/

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

static void touch_read(lv_indev_drv_t *s_indev_drv, lv_indev_data_t *data)
{
    data->state   = s_indev_state;
    data->point.x = s_indev_x;
    data->point.y = s_indev_y;

    if (s_indev_x > 160)
    {
        data->point.y = 230;
    }
}

void es_lvgl_gt91x_touch_read(void)
{
    uint8_t touch_state;
    struct es_touch_data touch_data;

    touch_state = gt911_touch_scan(&touch_data, 1);

    if (touch_state)
    {
        s_indev_state = LV_INDEV_STATE_PR;
        s_indev_x = touch_data.x_coordinate;
        s_indev_y = touch_data.y_coordinate;
    }
    else
    {
        s_indev_state = LV_INDEV_STATE_REL;
    }
}

void lv_port_disp_init(void)
{

#if (ES_LVGL_USE_2_DISP_BUF)
    lv_disp_draw_buf_init(&s_draw_buf_dsc, s_draw_buf_1, s_draw_buf_2, ES_LVGL_EACH_COLOR_DISP_BUF_SIZE);   /*Initialize the display buffer*/
#else
    lv_disp_draw_buf_init(&s_draw_buf_dsc, s_draw_buf_1, NULL, ES_LVGL_EACH_COLOR_DISP_BUF_SIZE);   /*Initialize the display buffer*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/

    lv_disp_drv_init(&s_es_disp_drv);                    /*Basic initialization*/

    /*Set the resolution of the display*/
    s_es_disp_drv.hor_res = ES_LVGL_LCD_DISP_HOR_RES;
    s_es_disp_drv.ver_res = ES_LVGL_LCD_DISP_VER_RES;

    /*Used to copy the buffer's content to the display*/
    s_es_disp_drv.flush_cb = es_lv_st7789_write_area;

    /*Set a display buffer*/
    s_es_disp_drv.draw_buf = &s_draw_buf_dsc;

    /*Finally register the driver*/
    lv_disp_drv_register(&s_es_disp_drv);
}

void lv_port_indev_init(void)
{
    lv_indev_drv_init(&s_indev_drv);
    s_indev_drv.type = LV_INDEV_TYPE_POINTER;
    s_indev_drv.read_cb = touch_read;
    lv_indev_drv_register(&s_indev_drv);
}

static void *es_lv_fs_open_cb(lv_fs_drv_t *drv, const char *path, lv_fs_mode_t mode)
{
    uint32_t index = ((path[0] - '0') * 100) + ((path[1] - '0') * 10) + (path[2] - '0');

    if (index >= ES_EXTERN_IMG_NUM)
        return NULL;

#if ES_LVGL_IMG_FILE_MEM_USE_MALLOC
    uint32_t *malloced_file_p = lv_mem_alloc(8);
    LV_ASSERT_MALLOC(malloced_file_p);

    /* *(malloced_file_p + 0) 图像id*/
    /* *(malloced_file_p + 1) 读取索引（针对lvgl文件系统）*/

    /*路径判断，转为图像表id*/
    *(malloced_file_p + 0) = index;
    *(malloced_file_p + 1) = 0;

    return malloced_file_p;
#else
    s_es_img_file_read_index[index] = 0;
    return &s_es_img_file_read_index[index];
#endif /*ES_LVGL_IMG_FILE_MEM_USE_MALLOC*/
}

lv_fs_res_t es_lv_fs_close_cb(struct _lv_fs_drv_t *drv, void *file_p)
{
#if ES_LVGL_IMG_FILE_MEM_USE_MALLOC
    lv_mem_free(file_p);
#endif /*ES_LVGL_IMG_FILE_MEM_USE_MALLOC*/

    return LV_FS_RES_OK;
}

lv_fs_res_t es_lv_fs_read_cb(struct _lv_fs_drv_t *drv, void *file_p, void *buf, uint32_t btr, uint32_t *br)
{
    uint32_t i;
#if ES_LVGL_IMG_FILE_MEM_USE_MALLOC
    uint32_t *malloced_file_p = (uint32_t *)(file_p);

    if (((*(malloced_file_p + 1)) == 0) && (btr == 4))
    {
        for (i = 0; i < btr; i++)
        {
            *((uint8_t *)buf + i) = *((uint8_t *)(&(g_es_ext_store_pictrue_info[(*(malloced_file_p + 0))].header)) + i);
        }
    }
    else
    {
        /*读取地址 = 图像像素偏移量 + 读取索引（针对lvgl文件系统）*/
        ll_flash_sector_read((uint8_t *)buf, g_es_ext_store_pictrue_info[(*(malloced_file_p + 0))].data_start + (((*(malloced_file_p + 1)) - 4)), btr);
    }

#else

    uint32_t index = ((uint32_t)file_p - (uint32_t)s_es_img_file_read_index) >> 2;

    if (((*(uint32_t *)(file_p)) == 0) && (btr == 4))
    {
        for (i = 0; i < btr; i++)
        {
            *((uint8_t *)buf + i) = *((uint8_t *)(&(g_es_ext_store_pictrue_info[index].header)) + i);
        }
    }
    else
    {
        /*读取地址 = 图像像素偏移量 + 读取索引（针对lvgl文件系统）*/
        ll_flash_sector_read((uint8_t *)buf, g_es_ext_store_pictrue_info[index].data_start + (*(uint32_t *)(file_p)) - 4, btr);
    }

#endif /*ES_LVGL_IMG_FILE_MEM_USE_MALLOC*/

    (*br) = btr;
    return LV_FS_RES_OK;
}

lv_fs_res_t es_lv_fs_seek_cb(lv_fs_drv_t *drv, void *file_p, uint32_t pos, lv_fs_whence_t whence)
{

#if ES_LVGL_IMG_FILE_MEM_USE_MALLOC
    uint32_t *malloced_file_p = (uint32_t *)(file_p);
    *(malloced_file_p + 1) = pos;
#else
    *(uint32_t *)(file_p) = pos;
#endif /*ES_LVGL_IMG_FILE_MEM_USE_MALLOC*/
    return LV_FS_RES_OK;
}

void es_lvgl_init(void)
{
#if LV_USE_LOG
#warning "need lv_log_register_print_cb()"
#endif /* LV_USE_LOG */
    lv_init();

    lv_fs_drv_init(&s_es_lv_fs_drv);                     /*Basic initialization*/

    s_es_lv_fs_drv.letter = 0x23;                     /*An uppercase letter to identify the drive */
    s_es_lv_fs_drv.open_cb = es_lv_fs_open_cb;                 /*Callback to open a file */
    s_es_lv_fs_drv.close_cb = es_lv_fs_close_cb;               /*Callback to close a file */
    s_es_lv_fs_drv.read_cb = es_lv_fs_read_cb;                 /*Callback to read a file */
    s_es_lv_fs_drv.seek_cb = es_lv_fs_seek_cb;                 /*Callback to seek in a file (Move cursor) */

    lv_fs_drv_register(&s_es_lv_fs_drv);                 /*Finally register the drive*/

    lv_port_disp_init();
    lv_port_indev_init();
}
