/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2023.04.07      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __ES_XMOD_H__
#define   __ES_XMOD_H__

/* Includes ------------------------------------------------------------------ */
#include "md_uart.h"
#include "md_crc.h"
#include "spi_flash.h"

/* Exported Macros ----------------------------------------------------------- */
#define XMODE_STX   0x02    /**< header of 1k-xmode  frames */
#define XMODE_EOT   0x04    /**< frame end byte */
#define XMODE_ACK   0x06    /**< frame ACK byte */
#define XMODE_NACK  0x15    /**< frame NACK byte */
#define XMODE_CAN   0x18    /**< revocation frame transmission */
#define XMODE_EOF   0x1A    /**< padding data */
#define XMODE_CRC   0x43    /**< CRC checkout frame */
#define TIME_OUT    3000    /**< timeout(ms) */
#define TRY_CNT     200 /**< repeat try number */
#define XMOD_UART   CUART1

/* Exported Types ------------------------------------------------------------ */

typedef enum
{
    XMOD_TX_CMD_START = XMODE_CRC,  /**< Start transfer */
    XMOD_TX_CMD_TERM  = XMODE_CAN,  /**< Terminal transfer */
    XMOD_TX_CMD_ACK   = XMODE_ACK,  /**< Acknowledgement */
    XMOD_TX_CMD_NCK   = XMODE_NACK, /**< Non-Acknowledgement */
} xmod_tx_cmd_t;

typedef enum
{
    FRAME_SUCCESS         = 0x01,   /**< Frame transmission sucess */
    FRAME_INDEX_ERROR     = 0x02,   /**< Frame index error */
    FRAME_RECEIVE_TIMEOUT = 0x04,   /**< Timeout error */
    FRAME_VERIFY_ERROR    = 0x08,   /**< Frame verigy error */
    UART_SEND_ERROR       = 0x10,   /**< UART send error */
    FLASH_WRITE_ERROR     = 0x20,   /**< Write flash error */
} frames_state_t;


typedef struct boot_frame_env_s
{
    uint16_t idx;           /**< Current index of receive frame */
    uint8_t cnt;            /**< Number of repetitions */
    frames_state_t state;       /**< State */
    uint8_t soh;            /**< Start of header */
} boot_frame_env_t;


/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
void update_spiflash(void);

#endif /*__ES_XMOD_H__*/

