/**********************************************************************************
 *
 * @file    .h
 * @brief   config.
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022-11-28      liuhy          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __ESSEMI_EXAMPLE_CONF_H__
#define __ESSEMI_EXAMPLE_CONF_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include "lv_conf.h"
#include "lvgl.h"
/* Exported Macros ----------------------------------------------------------- */

#define ES_BOARD_VERSION    20230506

/*屏幕显示驱动_ST7789*/
#define ES_LCD_SPI_PERIPHERAL    (SPI1)

#define ES_LCD_SPI_SCK_PIN_PORT       (GPIOB)
#define ES_LCD_SPI_SCK_PIN_MD_PIN     (MD_GPIO_PIN_13)
#define ES_LCD_SPI_SCK_PIN_MD_FUNC    (MD_GPIO_FUNC_2)

#define ES_LCD_SPI_MOSI_PIN_PORT       (GPIOB)
#define ES_LCD_SPI_MOSI_PIN_MD_PIN     (MD_GPIO_PIN_15)
#define ES_LCD_SPI_MOSI_PIN_MD_FUNC    (MD_GPIO_FUNC_2)

#define ES_LCD_RST_PIN_PORT      (GPIOA)
#define ES_LCD_RST_PIN_MD_PIN    (MD_GPIO_PIN_9)
#define ES_LCD_RST_PIN_MD_FUNC   (MD_GPIO_FUNC_1)

#define ES_LCD_CD_PIN_PORT       (GPIOC)
#define ES_LCD_CD_PIN_MD_PIN     (MD_GPIO_PIN_8)
#define ES_LCD_CD_PIN_MD_FUNC    (MD_GPIO_FUNC_1)

#define ES_LCD_BL_PIN_PORT       (GPIOA)
#define ES_LCD_BL_PIN_MD_PIN     (MD_GPIO_PIN_10)
#define ES_LCD_BL_PIN_MD_FUNC    (MD_GPIO_FUNC_1)

#define ES_LCD_SPI_SOFT_NSS_PIN_PORT      (GPIOC)
#define ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN    (MD_GPIO_PIN_9)
#define ES_LCD_SPI_SOFT_NSS_PIN_MD_FUNC   (MD_GPIO_FUNC_1)

/*屏幕触控驱动_GT91x*/
#define ES_TOUCH_USE_SOFT_I2C      1

#if ES_BOARD_VERSION < 20230506
    #if (ES_TOUCH_USE_SOFT_I2C == 0)
        #error "old board no support"
    #endif /*ES_TOUCH_USE_SOFT_I2C == 0*/
#endif /*ES_BOARD_VERSION < 20230506*/

#if ((ES_TOUCH_USE_SOFT_I2C) == 0)
    #define ES_TOUCH_I2C_PERIPHERAL    (I2C1)
#endif /*((ES_TOUCH_USE_SOFT_I2C) == 0)*/

#define ES_TOUCH_INT_PIN_PORT       (GPIOB)
#define ES_TOUCH_INT_PIN_MD_PIN     (MD_GPIO_PIN_1)
#define ES_TOUCH_INT_PIN_MD_FUNC    (MD_GPIO_FUNC_1)
#define ES_TOUCH_INT_IRQn           (EXTI0_3_IRQn)
#define ES_TOUCH_INT_IRQ_HANDLER     EXTI0_3_Handler

#define ES_TOUCH_RST_PIN_PORT       (GPIOC)
#define ES_TOUCH_RST_PIN_MD_PIN     (MD_GPIO_PIN_5)
#define ES_TOUCH_RST_PIN_MD_FUNC    (MD_GPIO_FUNC_1)

#define ES_TOUCH_I2C_SDA_PIN_PORT       (GPIOB)
#if ES_BOARD_VERSION >= 20230506
    #define ES_TOUCH_I2C_SDA_PIN_MD_PIN     (MD_GPIO_PIN_11)
#else
    #define ES_TOUCH_I2C_SDA_PIN_MD_PIN     (MD_GPIO_PIN_10)
#endif /*ES_BOARD_VERSION >= 20230506*/
#if (ES_TOUCH_USE_SOFT_I2C)
    #define ES_TOUCH_I2C_SDA_PIN_MD_FUNC    (MD_GPIO_FUNC_1)
#else
    #define ES_TOUCH_I2C_SDA_PIN_MD_FUNC    (MD_GPIO_FUNC_2)
#endif /*(ES_TOUCH_USE_SOFT_I2C)*/

#define ES_TOUCH_I2C_SCL_PIN_PORT       (GPIOB)
#if ES_BOARD_VERSION >= 20230506
    #define ES_TOUCH_I2C_SCL_PIN_MD_PIN     (MD_GPIO_PIN_10)
#else
    #define ES_TOUCH_I2C_SCL_PIN_MD_PIN     (MD_GPIO_PIN_0)
#endif /*ES_BOARD_VERSION >= 20230506*/
#if (ES_TOUCH_USE_SOFT_I2C)
    #define ES_TOUCH_I2C_SCL_PIN_MD_FUNC    (MD_GPIO_FUNC_1)
#else
    #define ES_TOUCH_I2C_SCL_PIN_MD_FUNC    (MD_GPIO_FUNC_2)
#endif /*(ES_TOUCH_USE_SOFT_I2C)*/


/*配置屏幕*/
/*    屏幕像素: 240 * 320*/
#define ES_LCD_WIDTH   240
#define ES_LCD_LENGTH  320

/*    屏幕状态*/
#if 1    /*屏幕xy轴是否交换 (1 << 5) */
    #define ES_LCD_X2Y_MASK             0x20
    #define ES_LCD_X2Y             ES_LCD_X2Y_MASK
#else
    #define ES_LCD_X2Y             0U
#endif /**/
#if 0    /*屏幕x轴是否翻转 (1 << 6) */
    #define ES_LCD_X_ORDER_MASK         0x40
    #define ES_LCD_X_ORDER             ES_LCD_X_ORDER_MASK
#else
    #define ES_LCD_X_ORDER             0U
#endif /**/
#if 1    /*屏幕y轴是否翻转 (1 << 7) */
    #define ES_LCD_Y_ORDER_MASK         0x80
    #define ES_LCD_Y_ORDER             ES_LCD_Y_ORDER_MASK
#else
    #define ES_LCD_Y_ORDER             0U
#endif /**/

/*配置LVGL*/
#define ES_LVGL_USE_2_DISP_BUF    1

#if (ES_LCD_X2Y)
    #define ES_LVGL_LCD_DISP_HOR_RES   ES_LCD_LENGTH
    #define ES_LVGL_LCD_DISP_VER_RES   ES_LCD_WIDTH
#else
    #define ES_LVGL_LCD_DISP_HOR_RES   ES_LCD_WIDTH
    #define ES_LVGL_LCD_DISP_VER_RES   ES_LCD_LENGTH
#endif /*(ES_LCD_X2Y)*/

#define ES_LVGL_EACH_COLOR_DISP_BUF_SIZE  (ES_LVGL_LCD_DISP_HOR_RES * 2)

/*部分底层接口*/
#define  ES_DELAY_MS(x)               md_delay_1ms((x))
#define  ES_DELAY_US(x)               md_delay_1us((x))
#define ES_LCD_RST_INT_OUT_HIGH()     {ES_LCD_RST_PIN_PORT->BSRR = (ES_LCD_RST_PIN_MD_PIN << GPIO_BSRR_BSR_POSS);}
#define ES_LCD_RST_INT_OUT_LOW()      {ES_LCD_RST_PIN_PORT->BSRR = (ES_LCD_RST_PIN_MD_PIN << GPIO_BSRR_BRR_POSS);}
#define ES_LCD1_SET_DATA()            {ES_LCD_CD_PIN_PORT->BSRR = (ES_LCD_CD_PIN_MD_PIN << GPIO_BSRR_BSR_POSS);}
#define ES_LCD1_SET_CMD()             {ES_LCD_CD_PIN_PORT->BSRR = (ES_LCD_CD_PIN_MD_PIN << GPIO_BSRR_BRR_POSS);}
#define ES_LCD_SPI_CS_OUTPUT_HIGH()   {ES_LCD_SPI_SOFT_NSS_PIN_PORT->BSRR = (ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN << GPIO_BSRR_BSR_POSS);}
#define ES_LCD_SPI_CS_OUTPUT_LOW()    {ES_LCD_SPI_SOFT_NSS_PIN_PORT->BSRR = (ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN << GPIO_BSRR_BRR_POSS);}

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */

extern uint32_t g_es_lvgl_lcd_tx_num;
extern uint16_t *g_es_lvgl_lcd_tx_buf;
extern volatile uint8_t g_es_lvgl_lcd_tx_complete;
#if (ES_LVGL_USE_2_DISP_BUF)
    extern lv_disp_drv_t *g_es_dma_flush_disp_drv;
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

void es_st7789_port_lcd_wrte_cmd(uint8_t cmd);
void es_st7789_port_lcd_wrte_data(uint8_t data);
void es_lv_st7789_write_area(lv_disp_drv_t *disp_drv, const lv_area_t *area, lv_color_t *color_p);
void es_lvgl_init(void);
void es_lvgl_gt91x_touch_read(void);
uint8_t es_touch_gt911_read_data(uint16_t addr, uint8_t cnt, uint8_t *buf);
uint8_t es_touch_gt911_write_data(uint16_t addr, uint8_t value);
void ui_init(void); /*SquareLine Studio 生成*/
void es_example_lv_time_callback1(void);
void es_mcu_init(void);

#endif /*__ESSEMI_EXAMPLE_CONF_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
