/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes-------------------------------------------------------------------*/
#include <fal.h>
#include <sfud.h>

#define FAL_USING_SFUD_PORT

#ifdef FAL_USING_SFUD_PORT
#ifdef RT_USING_SFUD
    #include <spi_flash_sfud.h>
#endif/*RT_USING_SFUD*/

#ifndef FAL_USING_NOR_FLASH_DEV_NAME
    #define FAL_USING_NOR_FLASH_DEV_NAME             "norflash0"
#endif/*FAL_USING_NOR_FLASH_DEV_NAME*/

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
static sfud_flash_t s_sfud_dev = NULL;
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
static int init(void);
static int read(long offset, uint8_t *buf, size_t size);
static int write(long offset, const uint8_t *buf, size_t size);
static int erase(long offset, size_t size);

/* Private Function ---------------------------------------------------------- */
struct fal_flash_dev nor_flash0 =
{
    .name       = FAL_USING_NOR_FLASH_DEV_NAME,
    .addr       = 0,
    .len        = 8 * 1024 * 1024,
    .blk_size   = 4096,
    .ops        = {init, read, write, erase},
    .write_gran = 1
};

static int init(void)
{

#ifdef RT_USING_SFUD
    /* RT-Thread RTOS platform */
    s_sfud_dev = rt_sfud_flash_find_by_dev_name(FAL_USING_NOR_FLASH_DEV_NAME);
#else
    /* bare metal platform */
    /*
        extern sfud_flash sfud_norflash0;
        s_sfud_dev = &sfud_norflash0;
    */
    s_sfud_dev = sfud_get_device(SFUD_MX25L64_DEVICE_INDEX);
#endif/*RT_USING_SFUD*/

    if (NULL == s_sfud_dev)
    {
        return -1;
    }

    /* update the flash chip information */
    nor_flash0.blk_size = s_sfud_dev->chip.erase_gran;
    nor_flash0.len = s_sfud_dev->chip.capacity;

    return 0;
}

static int read(long offset, uint8_t *buf, size_t size)
{
    assert(s_sfud_dev);
    assert(s_sfud_dev->init_ok);
    sfud_read(s_sfud_dev, nor_flash0.addr + offset, size, buf);

    return size;
}

static int write(long offset, const uint8_t *buf, size_t size)
{
    assert(s_sfud_dev);
    assert(s_sfud_dev->init_ok);

    if (sfud_write(s_sfud_dev, nor_flash0.addr + offset, size, buf) != SFUD_SUCCESS)
    {
        return -1;
    }

    return size;
}

static int erase(long offset, size_t size)
{
    assert(s_sfud_dev);
    assert(s_sfud_dev->init_ok);

    if (sfud_erase(s_sfud_dev, nor_flash0.addr + offset, size) != SFUD_SUCCESS)
    {
        return -1;
    }

    return size;
}
#endif /* FAL_USING_SFUD_PORT */

