/**********************************************************************************
 *
 * @file    uart.c
 * @brief   Main file for DEMO
 *
 * @date    9 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          9 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <stdio.h>
#include "uart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void uart_pin_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  uart function
  * @retval None.
  */
void mcu_uart_init(void)
{
    md_uart_init_t s_uart;

    uart_pin_init();

    md_uart_init_struct(&s_uart);
    s_uart.mode        = MD_UART_MODE;
    s_uart.baud        = 115200;
    s_uart.word_length = MD_UART_WORD_LENGTH_8B;
    s_uart.stop_bits   = MD_UART_STOP_BITS_1;
    s_uart.parity      = MD_UART_PARITY_NONE;
    s_uart.fctl        = MD_UART_FLOW_CTL_DISABLE;
    md_uart_init(CUART1, &s_uart);

    md_uart_enable_it_rfnempty(CUART1);
    md_mcu_irq_config(CUART1_IRQn, 3, ENABLE);
}

/**
  * @brief  uart pin function
  * @retval None.
  */
static void uart_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA, MD_GPIO_PIN_2, &gpio_init);

    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    md_gpio_init(GPIOA, MD_GPIO_PIN_3, &gpio_init);

}

int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        cnt = 4000;

        while ((READ_BIT(CUART1->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK && --cnt)
        {
        }

        md_uart_set_send_data8(CUART1, *ptr_char++);
    }

    return len;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
