/**********************************************************************************
 *
 * @file    iir_test.c
 * @brief   IIR test
 *
 * @date    17 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Jan. 2023    Shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "printf.h"
#include "test_timer.h"
#include "es32_dsp.h"

/* Private Macros ------------------------------------------------------------ */
#define TEST_LEN 32
#define TEST_COUNTS 10
#define TEST_CYCLES(f) start_timer(&t);for (uint32_t i=0;i<TEST_COUNTS;i++){for (int j=0;j<65536;j++){f;}}end_timer(&t);
#define TEST_SHOW_DATA 0

#define PID_LEN 32
#define PID_TARGET 1000
#define PID_STEP 2
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */
static int s_pid_out[PID_LEN];
static int16_t s_pid_coeff[3]={64,16,12};

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
void pid_test(void)
{
	test_timer_t t;
	int16_t val=0;
	
	pid_state_t pstate;
	pstate.Kp=s_pid_coeff[0];
	pstate.Ki=s_pid_coeff[1];
	pstate.Kd=s_pid_coeff[2];
	pstate.prev_err=0;
	pstate.integral=0;
	printf("PID (ASM1)\r\n");
	for (int i=0;i<PID_LEN;i++)
	{
		s_pid_out[i]=do_pid_state(PID_TARGET-val, &pstate);
		val+=((int)s_pid_out[i]*PID_STEP)>>8;
		printf("[%2d]=%d (Val=%d)\r\n",i,s_pid_out[i],val);
	}
	TEST_CYCLES(do_pid_state(PID_TARGET-val, &pstate));
	printf("%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
	
	printf("PID (ASM2)\r\n");
	reset_pid_asm(0,0);
	val=0;
	for (int i=0;i<PID_LEN;i++)
	{
		s_pid_out[i]=do_pid_asm(PID_TARGET-val, s_pid_coeff);
		val+=((int)s_pid_out[i]*PID_STEP)>>8;
		printf("[%2d]=%d (Val=%d)\r\n",i,s_pid_out[i],val);
	}
	TEST_CYCLES(do_pid_asm(PID_TARGET-val, s_pid_coeff));
	printf("%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
	
	printf("PID (C_1)\r\n");
	reset_pid_c(0,0);
	val=0;
	for (int i=0;i<PID_LEN;i++)
	{
		s_pid_out[i]=do_pid_c(PID_TARGET-val, s_pid_coeff);
		val+=((int)s_pid_out[i]*PID_STEP)>>8;
		printf("[%2d]=%d (Val=%d)\r\n",i,s_pid_out[i],val);
	}
	TEST_CYCLES(do_pid_c(PID_TARGET-val, s_pid_coeff));
	printf("%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
	
	printf("PID (C_2)\r\n");
	reset_pid_c(0,0);
	val=0;
	for (int i=0;i<PID_LEN;i++)
	{
		s_pid_out[i]=do_full_pid(val,PID_TARGET, s_pid_coeff);
		val+=((int)s_pid_out[i]*PID_STEP)>>8;
		printf("[%2d]=%d (Val=%d)\r\n",i,s_pid_out[i],val);
	}
	TEST_CYCLES(do_full_pid(val,PID_TARGET, s_pid_coeff));
	printf("%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
}