/**********************************************************************************
 *
 * @file    iir_test.c
 * @brief   IIR test
 *
 * @date    17 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Jan. 2023    Shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "es32_dsp.h"
#include "test_timer.h"
#include "main.h"
#include "printf.h"

/* Private Macros ------------------------------------------------------------ */
#define TEST_LEN 512
#define TEST_COUNTS 1000
#define TEST_CYCLES(f) start_timer(&t);for (int i=0;i<TEST_COUNTS;i++){f;}end_timer(&t);
#define TEST_SHOW_DATA 0

/* Private Constants --------------------------------------------------------- */
/* Shape=(512,) */
const int16_t IIR_DATA[512]={
16384,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16383,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16383,16760,9756,4196,8592,14687,13852,13569,21199,27779,24575,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8191,4988,11568,19198,18915,18080,24175,28571,23011,16007,16384,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8191,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16383,16760,9756,4196,8592,14687,13852,13569,21199,27779,24575,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8191,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24575,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
};

/* Shape=(4, 5) */
const int16_t IIR_COEF[20]={
-5316,2406,7,14,7,
-6375,2851,4096,8192,4096,
-5272,3218,4096,-8192,4096,
-7364,3669,4096,-8192,4096,
};

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */
static int16_t s_iir_output[TEST_LEN*2+2];
static uint16_t s_h2[5] = { 0x09c2, 0x270a, 0x3a8f, 0x270a, 0x09c2 };
static uint16_t s_h1[5] = { 0x7fff, 0xd24a, 0x72ca, 0xcf4e, 0x1ad4 };

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
void iir_test(void)
{
    test_timer_t t;
    
    /*
    IIR in ASM
    */
    TEST_CYCLES(iir_arma((uint16_t*)s_iir_output,(uint16_t*)IIR_DATA,s_h2,s_h1,TEST_LEN-4));
    printf("IIR1(ASM):%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
    #if TEST_SHOW_DATA
    for (int i=0;i<TEST_LEN;i++)
    {
        printf("%d\r\n",s_iir_output[i]);
    }
    #endif /* TEST_SHOW_DATA */
		
    /*
    IIR in C
    */
    TEST_CYCLES(iir_biquad((uint16_t*)s_iir_output,(uint16_t*)IIR_DATA,IIR_COEF,TEST_LEN));
    printf("IIR2(C)  :%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
    #if TEST_SHOW_DATA
    for (int i=0;i<TEST_LEN;i++)
    {
        printf("%d\r\n",s_iir_output[i]);
    }
    #endif /* TEST_SHOW_DATA */
	
    /*
    IIR in C
    */
    TEST_CYCLES(iir_biquad_pts(s_iir_output,IIR_DATA,IIR_COEF,TEST_LEN));
    printf("IIR2(C2)  :%uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNTS,1000000*TEST_COUNTS/get_timer_us(&t));
    #if TEST_SHOW_DATA
    for (int i=0;i<TEST_LEN;i++)
    {
        printf("%d\r\n",s_iir_output[i]);
    }
    #endif /* TEST_SHOW_DATA */
}