/**********************************************************************************
 *
 * @file    fir_test.c
 * @brief   FIR test
 *
 * @date    17 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Jan. 2023    Shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include "test_timer.h"
#include "printf.h"
#include "fir_data.h"
#include "es32_dsp.h"
/* Private Macros ------------------------------------------------------------ */
#define TEST_COUNT 1000
#define FIR_SHOW_DATA 0

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */
/* FIR in c (reference implementation) */
void c_fir(const int16_t* p_input, int*p_output, uint16_t data_len,const int16_t* p_fir_para,uint16_t fir_para_len);
void c_fir2(const int16_t* p_input, int*p_output, uint16_t data_len,const int16_t* p_fir_para,uint16_t fir_para_len);
void c_fir3(const int16_t* p_input, int*p_output, uint16_t data_len,const int16_t* p_fir_para,uint16_t fir_para_len);

/* Private Variables --------------------------------------------------------- */
static int s_output[1024];

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
void fir_test()
{    
	test_timer_t t;
	start_timer(&t);
	for (int i=0;i<TEST_COUNT;i++)
	{
		fir_16by16(s_output,FIR_TEST_DATA,1024,FIR_TEST_COEF,64);
	}
	end_timer(&t);
	printf("FIR(ASM) : %uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNT,1000000*TEST_COUNT/get_timer_us(&t));
	#if FIR_SHOW_DATA
	for (int i=0;i<1024;i++)
	{
		printf("%d\r\n",s_output[i]);
	}
	printf("\r\n");
	#endif /* FIR_SHOW_DATA */
	start_timer(&t);
	for (int i=0;i<TEST_COUNT;i++)
	{
		c_fir(FIR_TEST_DATA,s_output,1024,FIR_TEST_COEF,64);
	}
	end_timer(&t);
	printf("FIR(C)   : %uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNT,1000000*TEST_COUNT/get_timer_us(&t));
	#if FIR_SHOW_DATA
	for (int i=0;i<1024;i++)
	{
		printf("%d\r\n",s_output[i]);
	}
	printf("\r\n");
	#endif /* FIR_SHOW_DATA */
	
	start_timer(&t);
	for (int i=0;i<TEST_COUNT;i++)
	{
		c_fir2(FIR_TEST_DATA,s_output,1024,FIR_TEST_COEF,64);
	}
	end_timer(&t);
	printf("FIR(C2)  : %uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNT,1000000*TEST_COUNT/get_timer_us(&t));
	#if FIR_SHOW_DATA
	for (int i=0;i<1024;i++)
	{
		printf("%d\r\n",s_output[i]);
	}
	printf("\r\n");
	#endif /* FIR_SHOW_DATA */
		
	start_timer(&t);
	for (int i=0;i<TEST_COUNT;i++)
	{
		c_fir3(FIR_TEST_DATA,s_output,1024,FIR_TEST_COEF,64);
	}
	end_timer(&t);
	printf("FIR(C3)  : %uus(%u/s)\r\n",get_timer_us(&t)/TEST_COUNT,1000000*TEST_COUNT/get_timer_us(&t));
	#if FIR_SHOW_DATA
	for (int i=0;i<1024;i++)
	{
		printf("%d\r\n",s_output[i]);
	}
	printf("\r\n");
	#endif /* FIR_SHOW_DATA */
}