/**********************************************************************************
 *
 * @file    c_fir.c
 * @brief   FIR implemention in C
 *
 * @date    17 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Jan. 2023    Shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <stdint.h>
#include <string.h>

/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/*
C语言实现FIR滤波器-时域暴力卷积方法
y(n) = E(m=0->N-1) x(m)*h(n-m);
p_input : 待滤波数据
p_output ： 滤波输出数据
data_len ： 数据长度
p_fir_para ： h(t)参数
fir_para_len ： h(t)长度
*/
void c_fir(int16_t* p_input, int*p_output, uint16_t data_len, int16_t* p_fir_para,uint16_t fir_para_len)
{
    for (uint16_t i = 0; i < data_len; i++)
    {
		p_output[i]=0;
        if (i < fir_para_len)
        {
            for (uint16_t j = 0; j <= i; j++)
            {
                p_output[i] += p_fir_para[j] * p_input[i - j];
            }
        }
        else if(i >= fir_para_len)
        {
            for (uint16_t j = 0; j < fir_para_len; j++)
            {
                p_output[i] += p_fir_para[j] * p_input[i - j];  /* 卷积和 */
            }

        }
    }
}

void c_fir2(int16_t* p_input, int*p_output, uint16_t data_len, int16_t* p_fir_para,uint16_t fir_para_len)
{
    memset(p_output, 0, sizeof(int) * data_len);  /* 输出清零 */
	
	for (int i=0;i<data_len;i++)
	{
		int val=p_input[i];
		int len=(i+fir_para_len<data_len)?fir_para_len:data_len-i;
		for (int j=0;j<len;j++)
		{
			p_output[i+j]+=val*p_fir_para[j];
		}
	}
}

void c_fir3(int16_t* p_input, int*p_output, uint16_t data_len, int16_t* p_fir_para,uint16_t fir_para_len)
{
	while (data_len>0)
	{
		int flen=fir_para_len;
		int x0=p_input[0];
		int x1=p_input[1];
		int x2=p_input[2];
		int x3=p_input[3];
		int y0=0;
		int y1=0;
		int y2=0;
		int y3=0;
		int c;
		#define x4 x0
		#define x5 x1
		#define x6 x2
		#define x7 x3
		while (flen>0)
		{
			c=p_fir_para[0];
			y0+=c*x0;
			y1+=c*x1;
			y2+=c*x2;
			y3+=c*x3;
			
			c=p_fir_para[1];
			x4=p_input[4];
			y0+=c*x1;
			y1+=c*x2;
			y2+=c*x3;
			y3+=c*x4;
			
			c=p_fir_para[2];
			x5=p_input[5];
			y0+=c*x2;
			y1+=c*x3;
			y2+=c*x4;
			y3+=c*x5;
			
			c=p_fir_para[3];
			x6=p_input[6];
			y0+=c*x3;
			y1+=c*x4;
			y2+=c*x5;
			y3+=c*x6;
			
			x7=p_input[7];
			
			p_input+=4;
			p_fir_para+=4;
			flen-=4;
		}
		p_output[0]=y0;
		p_output[1]=y1;
		p_output[2]=y2;
		p_output[3]=y3;
		p_input+=4;
		p_output+=4;
		data_len-=4;
	}
}