/**********************************************************************************
 *
 * @file    fir_test.c
 * @brief   FIR test
 *
 * @date    09 Feb  2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Feb  2023    AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
/* Includes ------------------------------------------------------------------ */
#include "es32_dsp.h"
#include "printf.h"
/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */
/* Shape=(1152,) */
const int16_t FIR_DATA[1152]={
1076,1042,1078,1125,1175,1124,1185,1157,1199,1236,1160,1198,1196,1219,1267,1309,
1265,1243,1312,1334,1363,1330,1374,1328,1396,1398,1386,1372,1394,1444,1395,1479,
1515,1469,1466,1548,1510,1509,1486,1499,1581,1529,1543,1634,1598,1648,1593,1584,
1645,1702,1647,1685,1723,1719,1662,1706,1716,1728,1732,1747,1775,1797,1807,1746,
1835,1802,1817,1862,1816,1802,1822,1880,1820,1857,1849,1852,1924,1883,1952,1926,
1952,1936,1983,1989,1948,1916,1979,1965,1972,1936,2002,2025,2052,1993,1995,2016,
2051,2066,2028,1996,2073,2042,2041,2076,2004,2019,2067,2017,2052,2063,2059,2088,
2100,2091,2052,2125,2128,2138,2138,2143,2110,2080,2119,2134,2077,2139,2141,2066,
2097,2071,2092,2116,2128,2107,2127,2110,2139,2144,2099,2109,2058,2049,2071,2055,
2065,2079,2050,2052,2019,2052,2110,2089,2052,2032,2059,1994,2060,2004,2017,2000,
2000,2019,2022,2008,2014,2018,1968,2020,1937,2007,2005,1920,1974,1902,1949,1901,
1922,1961,1946,1862,1872,1850,1894,1910,1827,1874,1885,1872,1817,1848,1792,1839,
1814,1756,1796,1813,1777,1777,1746,1774,1705,1718,1676,1711,1635,1641,1673,1625,
1692,1665,1587,1641,1645,1569,1568,1525,1594,1568,1499,1490,1493,1499,1524,1428,
1460,1438,1468,1411,1465,1448,1352,1431,1346,1326,1301,1383,1287,1350,1289,1275,
1275,1220,1246,1232,1222,1164,1159,1239,1196,1178,1104,1096,1172,1151,1115,1123,
1059,1091,1070,1067,975,1027,971,983,971,923,946,978,915,872,881,859,
853,812,894,866,850,775,805,769,739,779,715,783,727,768,678,658,
651,642,682,685,658,612,658,606,642,547,618,515,558,540,482,518,
476,504,436,445,460,442,494,435,417,391,403,405,345,403,382,405,
359,308,365,340,275,343,315,329,280,324,265,217,236,248,190,231,
219,212,201,238,217,159,136,192,142,121,134,146,175,124,181,125,
99,166,105,78,149,86,105,128,52,56,94,127,101,57,29,73,
111,48,54,98,17,78,106,25,36,52,35,33,21,66,100,99,
48,2,32,87,36,6,17,74,103,53,83,72,31,115,101,116,
96,23,53,119,88,67,70,71,108,145,71,152,76,151,121,125,
169,128,178,120,118,136,206,195,140,218,188,151,213,186,248,257,
173,277,210,236,290,237,310,258,234,250,323,335,341,281,365,370,
357,357,410,421,408,359,356,381,444,448,476,418,460,426,471,510,
509,523,487,516,549,552,580,566,642,576,625,630,676,656,657,708,
635,741,740,750,767,738,784,715,736,812,789,858,874,859,863,859,
862,855,937,958,940,958,901,968,961,993,975,1039,1015,991,1016,1071,
1086,1118,1075,1162,1144,1153,1139,1129,1173,1179,1171,1196,1235,1229,1263,1281,
1311,1307,1312,1334,1352,1378,1383,1322,1418,1344,1369,1389,1465,1454,1410,1440,
1458,1496,1540,1462,1512,1552,1520,1534,1534,1542,1557,1565,1597,1601,1587,1645,
1643,1675,1635,1719,1660,1727,1682,1736,1724,1784,1778,1757,1801,1816,1773,1823,
1758,1814,1848,1859,1828,1794,1861,1890,1888,1910,1858,1885,1945,1942,1906,1879,
1936,1973,1982,1910,1937,1940,2002,2005,1974,1973,1995,1997,2008,2023,2056,1973,
2034,2042,2047,2031,2071,2067,2071,2017,2025,2013,2070,2097,2054,2025,2045,2038,
2049,2068,2124,2095,2121,2051,2074,2053,2120,2101,2100,2064,2142,2112,2123,2072,
2146,2101,2091,2106,2128,2080,2140,2133,2115,2108,2110,2051,2093,2085,2052,2125,
2061,2087,2117,2099,2056,2038,2018,2049,2092,2095,2090,1998,2019,2058,1982,1999,
1970,2015,2054,2017,2032,2031,1995,1982,1987,1968,2014,1959,1919,1923,1985,1911,
1944,1871,1929,1903,1870,1855,1895,1900,1876,1874,1842,1861,1793,1825,1810,1777,
1817,1760,1825,1743,1779,1777,1715,1757,1757,1750,1724,1648,1650,1637,1697,1678,
1694,1622,1586,1657,1570,1574,1535,1603,1568,1564,1526,1557,1493,1548,1538,1459,
1462,1490,1470,1398,1383,1444,1400,1337,1342,1409,1367,1329,1326,1315,1321,1338,
1303,1279,1232,1263,1196,1167,1165,1148,1197,1146,1122,1145,1114,1099,1135,1119,
1109,1016,1060,1026,989,1029,991,946,1023,988,920,971,973,909,870,916,
906,833,893,860,844,800,799,754,776,728,778,712,755,679,746,668,
644,647,700,652,603,632,569,640,555,632,575,552,508,565,553,476,
535,540,492,442,460,492,454,418,405,449,364,424,406,346,375,352,
316,335,351,373,282,342,263,296,240,244,312,286,244,202,194,249,
208,259,213,154,237,230,151,177,166,207,189,108,110,184,156,162,
134,95,150,126,139,107,131,69,80,123,121,114,80,40,124,58,
31,38,101,91,112,17,20,23,105,101,76,87,97,84,4,42,
58,75,51,97,18,48,37,44,100,104,94,57,22,32,27,23,
74,89,44,105,132,75,100,119,81,146,142,155,97,118,75,75,
91,166,181,132,114,160,127,180,178,187,194,187,219,223,237,205,
233,236,228,249,279,265,244,297,331,281,327,326,350,337,363,339,
350,319,396,398,412,384,432,430,440,420,400,443,490,502,499,489,
522,531,481,588,588,540,549,575,622,557,588,616,663,609,618,632,
660,693,692,753,725,780,761,786,814,757,816,808,845,882,893,815,
841,938,923,925,875,933,939,943,941,1016,970,978,1018,1018,1053,1041,
1059,1043,1058,1152,1150,1155,1198,1120,1133,1195,1234,1167,1252,1227,1295,1271,
1310,1327,1335,1348,1349,1293,1353,1381,1331,1428,1373,1450,1438,1406,1395,1438,
1482,1452,1464,1512,1493,1518,1507,1537,1608,1553,1579,1571,1561,1600,1635,1654,
1619,1613,1706,1636,1646,1732,1705,1684,1771,1704,1760,1754,1804,1822,1771,1813,
1764,1818,1793,1871,1824,1838,1878,1851,1908,1841,1833,1904,1905,1945,1913,1920,
1894,1978,1982,1910,1974,1989,1962,1940,1935,1953,2025,1982,2036,1984,2014,2030,
2034,2068,2029,1986,2059,2003,2065,2075,2017,2011,2107,2113,2025,2059,2089,2053,
2030,2101,2067,2125,2056,2087,2056,2067,2092,2070,2072,2144,2077,2062,2127,2090,
};
const int16_t FIR_TEST_COEF[64] =
{
    52,     55,     62,     71,     85,    102,    123,    148,    176,
    208,    244,    282,    324,    368,    414,    462,    511,    561,
    610,    660,    708,    755,    799,    841,    880,    915,    946,
    972,    994,   1010,   1021,   1027,   1027,   1021,   1010,    994,
    972,    946,    915,    880,    841,    799,    755,    708,    660,
    610,    561,    511,    462,    414,    368,    324,    282,    244,
    208,    176,    148,    123,    102,     85,     71,     62,     55,
    52
};

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
static int s_output[1024];

/* Private Function ---------------------------------------------------------- */
void fir_test()
{    
	fir_16by16(s_output,FIR_DATA,1024,FIR_TEST_COEF,64);
	for (int i=0;i<1024;i++)
	{
		printf("%d\r\n",s_output[i]);
	}
	printf("\r\n");
	
}