/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "usbh_core.h"
#include "usbh_hub.h"
#include "usbh_hid.h"
#include "FreeRTOS.h"
#include "task.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
USB_NOCACHE_RAM_SECTION USB_MEM_ALIGNX uint8_t g_hid_buffer[64];
struct usbh_urb g_hid_intin_urb;

/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
static void usbh_hid_callback(void *arg, int nbytes)
{
    size_t i;
    struct usbh_hid *hid_class = (struct usbh_hid *)arg;

    if (nbytes > 0)
    {
        for (i = 0; i < nbytes; i++)
            printf("0x%02x ", g_hid_buffer[i]);

        printf("\r\n");
    }

    usbh_int_urb_fill(&g_hid_intin_urb, hid_class->hport,  hid_class->intin, g_hid_buffer, hid_class->intin->wMaxPacketSize, 0, usbh_hid_callback, hid_class);
    usbh_submit_urb(&g_hid_intin_urb);
}

void usbh_hid_run(struct usbh_hid *hid_class)
{
	g_hid_intin_urb.errorcode = 0;
    usbh_int_urb_fill(&g_hid_intin_urb, hid_class->hport,  hid_class->intin, g_hid_buffer, hid_class->intin->wMaxPacketSize, 0, usbh_hid_callback, hid_class);
    usbh_submit_urb(&g_hid_intin_urb);
}

void usbh_hid_stop(struct usbh_hid *hid_class)
{

}

/* Public Function ---------------------------------------------------------- */

/*******************************************************END OF FILE*************/
