/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes-------------------------------------------------------------------*/
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_key_press_flag = 0U;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

int _write(int file, const void *ptr, int len)
{
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        while ((READ_BIT(CUART1->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK)
        {
        }

        md_uart_set_send_data8(CUART1, *ptr_char++);
    }

    return len;
}

void usb_dc_low_level_init(void)
{

}

static void uart_stdio_init(void)
{
    md_gpio_init_t  gpio_config;
    md_uart_init_t  uart_handle;

    md_gpio_init_struct(&gpio_config);
    /* Initialize tx pin */
    gpio_config.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos  = MD_GPIO_PUSH_PULL;
    gpio_config.pupd  = MD_GPIO_PUSH_UP;
    gpio_config.odrv  = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_CMOS;
    gpio_config.func  = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA, MD_GPIO_PIN_2, &gpio_config);

    gpio_config.mode  = MD_GPIO_MODE_INPUT;
    md_gpio_init(GPIOA, MD_GPIO_PIN_3, &gpio_config);

    /* Initialize UART */
    md_uart_init_struct(&uart_handle);
    uart_handle.baud        = 115200;
    uart_handle.word_length = MD_UART_WORD_LENGTH_8B;
    uart_handle.stop_bits   = MD_UART_STOP_BITS_1;
    uart_handle.parity      = MD_UART_PARITY_NONE;
    uart_handle.fctl        = MD_UART_FLOW_CTL_DISABLE;
    uart_handle.mode        = MD_UART_MODE;
    md_uart_init(CUART1, &uart_handle);
}

/**
  * @brief user_system_config system configuration.
  * @param none
  * @retval none
  */
static void user_system_config(void)
{
#ifdef ES_USB_USE_48M_PLL
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);

    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    md_cmu_sel_usbclk_pll();/*选择PLLCLK作为USB时钟（48M）*/
    md_cmu_enable_usbck48();/*USB 48M使能*/
    MD_SYSCFG_LOCK();
#else
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    md_cmu_enable_usbck48();/*USB 48M使能*/
    md_csu_enable_auto();
    md_csu_enable_cnt();
    MD_SYSCFG_LOCK();
#endif/*ES_USB_USE_48M_PLL*/
    md_rmu_reset_periperal(MD_RMU_PERH_USB);
    md_init_1ms_tick();
    __enable_irq();

    return;
}

/**
  * @brief  Initializate exit.
  * @retval None
  */
void exti_init(void)
{
    md_gpio_init_t gpio_init;

    /* Initialize KEY pin */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(KEY1_PORT, KEY1_PIN, &gpio_init);
    md_gpio_init(KEY2_PORT, KEY2_PIN, &gpio_init);
    md_gpio_init(KEY3_PORT, KEY3_PIN, &gpio_init);
    md_gpio_init(KEY4_PORT, KEY4_PIN, &gpio_init);
    md_gpio_init(KEY5_PORT, KEY5_PIN, &gpio_init);
}

/**
  * @brief main.
  * @param none
  * @retval none
  */
int main(void)
{
    user_system_config();
    uart_stdio_init();

    /* Initialize exti */
    exti_init();

    printf("\rSystem start...\r\n");

    cdc_acm_hid_winusb_descriptor_init();

    while (1)
    {
        usb_dev_loop();
    }
}

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE ****/
