/**
  *********************************************************************************
  *
  * @file    .c
  * @brief  Source file
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "shell.h"
#include "ff_gen_drv.h"

/* Private Macros ------------------------------------------------------------ */
#define UART_BUF_LEN 128

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

static uint32_t list_cmd(void)
{
    qsh_record_t *Index;

    for (Index = (qsh_record_t *) &g_qShellFunTab$$Base; Index < (qsh_record_t *) &g_qShellFunTab$$Limit; Index ++)
    {
        printf("%s\r\n", Index->desc);
    }

    return 0;
}
QSH_FUN_REG(list_cmd, "uint32_t list_cmd(void)");

static uint32_t refresh(void)
{
    es_try_fatfs_unregister();
    es_fatfs_register();

    return 0;
}
QSH_FUN_REG(refresh, "uint32_t refresh(void)");

static uint32_t make_dir(char *input_fullpath)
{
    FRESULT res;

    if ((input_fullpath[0]) && (input_fullpath))
    {
        res = f_mkdir(input_fullpath);

        if (res == FR_OK)
            printf("make dir success\r\n");
        else
            printf("make dir fail\r\n");
    }
    else
        printf("input_fullpath error\r\n");

    return 0;
}
QSH_FUN_REG(make_dir, "uint32_t make_dir(char* input_fullpath)");

static uint32_t write_file(char *input_fullpath, char *write_buf)
{
    FIL fp[1];
    FRESULT res;
    FILINFO fno;
    unsigned int get_num;

    if ((input_fullpath[0]) && (input_fullpath))
    {
        res = f_stat(input_fullpath, &fno);

        if (res != FR_OK)
            fno.fsize = 0;

        res = f_open(fp, input_fullpath, FA_CREATE_ALWAYS | FA_WRITE);

        if (res == FR_OK)
        {
            res = f_lseek(fp, fno.fsize);

            if (res == FR_OK)
            {
                res = f_write(fp, write_buf, strlen(write_buf), &get_num);

                if (res == FR_OK)
                {
                    printf("file write succes\r\n");
                }
                else
                    es_fatfs_error_handler();
            }
            else
                es_fatfs_error_handler();

            res = f_close(fp);

            if (res != FR_OK)
                es_fatfs_error_handler();
        }
        else
            printf("file open fail\r\n");
    }
    else
        printf("input_fullpath error\r\n");

    return 0;
}
QSH_FUN_REG(write_file, "uint32_t write_file(char *input_fullpath, char *write_buf)");

static uint32_t read_file(char *input_fullpath)
{
    FIL fp[1];
    FRESULT res;
    uint32_t i;
    FILINFO fno;
    uint8_t temp_buf[16];
    unsigned int get_num;

    if ((input_fullpath[0]) && (input_fullpath))
    {
        res = f_stat(input_fullpath, &fno);

        if (res == FR_OK)
        {
            printf("file_name:%s\r\n", fno.fname);
            printf("file_size:%d\r\n", (unsigned int)(fno.fsize));

            res = f_open(fp, input_fullpath, FA_READ);

            if (res == FR_OK)
            {
                while (1)
                {
                    res = f_read(fp, temp_buf, 16, &get_num);

                    if (res == FR_OK)
                    {
                        for (i = 0; i < get_num; i++)
                        {
                            printf("%c", temp_buf[i]);
                        }
                    }

                    if ((res != FR_OK) || (get_num == 0))
                        break;
                }

                printf("\r\n");

                res = f_close(fp);

                if (res != FR_OK)
                    es_fatfs_error_handler();
            }
            else
                printf("file open fail\r\n");
        }
        else
            printf("read file stat fail\r\n");
    }
    else
        printf("input_fullpath error\r\n");

    return 0;
}
QSH_FUN_REG(read_file, "uint32_t read_file(char* input_fullpath)");

static uint32_t move_rename(char *old_fullpath, char *new_fullpath)
{
    if ((old_fullpath) && (new_fullpath) && (old_fullpath[0]) && (new_fullpath[0]))
    {
        if (FR_OK == (f_rename(old_fullpath, new_fullpath)))
            printf("rename success\r\n");
        else
            printf("rename fail\r\n");
    }
    else
        printf("input_fullpath error\r\n");

    return 0;
}
QSH_FUN_REG(move_rename, "uint32_t move_rename(char* old_fullpath,char* new_fullpath)");

static uint32_t rm_file(char *input_fullpath)
{
    char *fullpath;
    FRESULT res;

    if ((input_fullpath[0]) && (input_fullpath))
    {
        fullpath = input_fullpath;

        res = f_unlink(fullpath);

        if (res == FR_OK)
        {
            printf("\r\nremove file succes:%s\r\n", fullpath);
        }
        else
        {
            printf("\r\nremove file fail\r\n");
        }
    }
    else
    {
        printf("input_fullpath error\r\n");
    }

    return 0;
}
QSH_FUN_REG(rm_file, "uint32_t rm_file(char* input_fullpath)");

static FRESULT scan_files_del(char *path)
{
    FRESULT res;
    DIR dir;
    UINT i;
    static FILINFO fno;

    res = f_opendir(&dir, path);/*打开此文件夹*/

    if (res == FR_OK)/*成功打开文件夹*/
    {
        while (1) /*循环扫描文件夹和文件*/
        {
            res = f_readdir(&dir, &fno);/*读取此文件夹中的一个子文件*/

            if (res != FR_OK || fno.fname[0] == 0)
                break;/*读取错误或者已经扫描完此文件夹下的所有文件，跳出循环*/

            if (fno.fattrib & AM_DIR) /*子文件为文件夹*/
            {
                i = strlen(path);/*统计附文件夹路径长度*/
                sprintf((char *)&path[i], "\\%s", fno.fname); /*将子文件夹名加入路径*/
                res = scan_files_del(path);/*递归进入子文件夹，扫描文件夹*/

                if (res != FR_OK)
                    break;/*操作失败跳出循环*/

                path[i] = 0; /*文件路径回退*/
            }
            else /*子文件为  文件类型*/
            {
                i = strlen(path);/*统计附文件夹路径长度*/
                sprintf((char *)&path[i], "\\%s", fno.fname); /*将子文件名加入路径*/
                res = f_unlink(path); /*删除子文件*/
                path[i] = 0; /*文件路径回退*/
            }
        }

        res = f_closedir(&dir);/*关闭已打开的父文件夹*/
        res = f_unlink(path);/*删除已经清空的父文件夹*/
    }

    return res;
}

static uint32_t rm_dir(char *input_fullpath)
{
    static char fullpath[256];

    if ((input_fullpath[0]) && (input_fullpath))
    {
        strcpy(fullpath, input_fullpath);
        scan_files_del(fullpath);
    }
    else
        printf("input_fullpath error\r\n");

    return 0;
}
QSH_FUN_REG(rm_dir, "uint32_t rm_dir(char* input_fullpath)");

static uint32_t read_dir(char *input_fullpath)
{
    char *default_fullpath = "0:/";
    char *fullpath = default_fullpath;
    DIR dir;
    FILINFO fno;
    FRESULT res;

    if ((input_fullpath[0]) && (input_fullpath))
        fullpath = input_fullpath;
    else
        printf("use default_fullpath\r\n");

    res = f_opendir(&dir, fullpath);

    if (res == FR_OK)
    {
        printf("\r\n%s\r\n", fullpath);

        while (1)
        {
            res = f_readdir(&dir, &fno);

            if ((res != FR_OK) || (fno.fname[0] == '\0'))
                break;

            printf("%-32s ", fno.fname);

            if ((fno.fattrib) & (AM_DIR))
                printf("<DIR>\r\n");
            else
                printf("%d\r\n", (unsigned int)(fno.fsize));
        }

        res = f_closedir(&dir);

    }
    else
    {
        es_fatfs_error_handler();
    }

    return 0;
}
QSH_FUN_REG(read_dir, "uint32_t read_dir(char* input_fullpath)");
