/**
  *
  * Licensed to the Apache Software Foundation (ASF) under one or more
  * contributor license agreements.  See the NOTICE file distributed with
  * this work for additional information regarding copyright ownership.  The
  * ASF licenses this file to you under the Apache License, Version 2.0 (the
  * "License"); you may not use this file except in compliance with the
  * License.  You may obtain a copy of the License at
  *
  *   http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
  * License for the specific language governing permissions and limitations
  * under the License.
  *
  */


#ifndef WBVAL
#define WBVAL(x) (unsigned char)((x) & 0xFF), (unsigned char)(((x) >> 8) & 0xFF)
#endif




/*!< USBD CONFIG */
#define USBD_VERSION 0x0200
#define USBD_PRODUCT_VERSION 0x0001
#define USBD_VID 0x30cc
#define USBD_PID 0xae04
#define USBD_MAX_POWER 0xfa
#define USBD_LANGID_STRING 1033
#define USBD_CONFIG_DESCRIPTOR_SIZE 130




/*!< USBD ENDPOINT CONFIG */

#define USBD_IF0_AL0_EP0_ADDR 0x81
#define USBD_IF0_AL0_EP0_SIZE 0x08
#define USBD_IF0_AL0_EP0_INTERVAL 0x0a

#define USBD_IF1_AL0_EP0_ADDR 0x02
#define USBD_IF1_AL0_EP0_SIZE 0x40
#define USBD_IF1_AL0_EP0_INTERVAL 0x00

#define USBD_IF1_AL0_EP1_ADDR 0x82
#define USBD_IF1_AL0_EP1_SIZE 0x40
#define USBD_IF1_AL0_EP1_INTERVAL 0x00

#define USBD_IF2_AL0_EP0_ADDR 0x03
#define USBD_IF2_AL0_EP0_SIZE 0x40
#define USBD_IF2_AL0_EP0_INTERVAL 0x00

#define USBD_IF2_AL0_EP1_ADDR 0x83
#define USBD_IF2_AL0_EP1_SIZE 0x40
#define USBD_IF2_AL0_EP1_INTERVAL 0x00

#define USBD_IF3_AL0_EP0_ADDR 0x04
#define USBD_IF3_AL0_EP0_SIZE 0x40
#define USBD_IF3_AL0_EP0_INTERVAL 0x00

#define USBD_IF3_AL0_EP1_ADDR 0x84
#define USBD_IF3_AL0_EP1_SIZE 0x40
#define USBD_IF3_AL0_EP1_INTERVAL 0x00




/*!< USBD HID CONFIG */
#define USBD_HID_VERSION 0x0111
#define USBD_HID_COUNTRY_CODE 0
#define USBD_IF2_AL0_HID_REPORT_DESC_SIZE 2




/*!< USBD Descriptor */
const unsigned char usbd_descriptor[] = {   
/********************************************** Device Descriptor */
    0x12,                                       /*!< bLength */
    0x01,                                       /*!< bDescriptorType */
    WBVAL(USBD_VERSION),                        /*!< bcdUSB */
    0xef,                                       /*!< bDeviceClass */
    0x02,                                       /*!< bDeviceSubClass */
    0x01,                                       /*!< bDeviceProtocol */
    0x40,                                       /*!< bMaxPacketSize */
    WBVAL(USBD_VID),                            /*!< idVendor */
    WBVAL(USBD_PID),                            /*!< idProduct */
    WBVAL(USBD_PRODUCT_VERSION),                /*!< bcdDevice */
    0x01,                                       /*!< iManufacturer */
    0x02,                                       /*!< iProduct */
    0x03,                                       /*!< iSerial */
    0x01,                                       /*!< bNumConfigurations */
/********************************************** Config Descriptor */
    0x09,                                       /*!< bLength */
    0x02,                                       /*!< bDescriptorType */
    WBVAL(USBD_CONFIG_DESCRIPTOR_SIZE),         /*!< wTotalLength */
    0x04,                                       /*!< bNumInterfaces */
    0x01,                                       /*!< bConfigurationValue */
    0x00,                                       /*!< iConfiguration */
    0x80,                                       /*!< bmAttributes */
    USBD_MAX_POWER,                             /*!< bMaxPower */
/********************************************** Interface Associate Descriptor */
    0x08,                                       /*!< bLength */
    0x0b,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bFirstInterface */
    0x02,                                       /*!< bInterfaceCount */
    0x02,                                       /*!< bFunctionClass */
    0x02,                                       /*!< bFunctionSubClass */
    0x01,                                       /*!< bFunctionProtocol */
    0x00,                                       /*!< iFunction */
/********************************************** Interface 0 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x01,                                       /*!< bNumEndpoints */
    0x02,                                       /*!< bInterfaceClass */
    0x02,                                       /*!< bInterfaceSubClass */
    0x01,                                       /*!< bInterfaceProtocol */
    0x04,                                       /*!< iInterface */
/********************************************** Class Specific Descriptor of CDC ACM Control */
    0x05,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bDescriptorSubtype */
    WBVAL(0x0110),                              /*!< bcdCDC */
    0x05,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x01,                                       /*!< bDescriptorSubtype */
    0x00,                                       /*!< bmCapabilities */
    0x01,                                       /*!< bDataInterface */
    0x04,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x02,                                       /*!< bDescriptorSubtype */
    0x02,                                       /*!< bmCapabilities */
    0x05,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x06,                                       /*!< bDescriptorSubtype */
    0x00,                                       /*!< bMasterInterface */
    0x01,                                       /*!< bSlaveInterface0 */
/********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF0_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x03,                                       /*!< bmAttributes */
    WBVAL(USBD_IF0_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF0_AL0_EP0_INTERVAL,                  /*!< bInterval */
/********************************************** Interface 1 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x01,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x02,                                       /*!< bNumEndpoints */
    0x0a,                                       /*!< bInterfaceClass */
    0x00,                                       /*!< bInterfaceSubClass */
    0x00,                                       /*!< bInterfaceProtocol */
    0x05,                                       /*!< iInterface */
/********************************************** Class Specific Descriptor of CDC ACM Data */
/********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF1_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF1_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF1_AL0_EP0_INTERVAL,                  /*!< bInterval */
/********************************************** Endpoint 1 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF1_AL0_EP1_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF1_AL0_EP1_SIZE),               /*!< wMaxPacketSize */
    USBD_IF1_AL0_EP1_INTERVAL,                  /*!< bInterval */
/********************************************** Interface 2 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x02,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x02,                                       /*!< bNumEndpoints */
    0x03,                                       /*!< bInterfaceClass */
    0x00,                                       /*!< bInterfaceSubClass */
    0x00,                                       /*!< bInterfaceProtocol */
    0x06,                                       /*!< iInterface */
/********************************************** Class Specific Descriptor of HID */
    0x09,                                       /*!< bLength */
    0x21,                                       /*!< bDescriptorType */
    WBVAL(USBD_HID_VERSION),                    /*!< bcdHID */
    USBD_HID_COUNTRY_CODE,                      /*!< bCountryCode */
    0x01,                                       /*!< bNumDescriptors */
    0x22,                                       /*!< bDescriptorType */
    WBVAL(USBD_IF2_AL0_HID_REPORT_DESC_SIZE),   /*!< wItemLength */
/********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF2_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x03,                                       /*!< bmAttributes */
    WBVAL(USBD_IF2_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF2_AL0_EP0_INTERVAL,                  /*!< bInterval */
/********************************************** Endpoint 1 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF2_AL0_EP1_ADDR,                      /*!< bEndpointAddress */
    0x03,                                       /*!< bmAttributes */
    WBVAL(USBD_IF2_AL0_EP1_SIZE),               /*!< wMaxPacketSize */
    USBD_IF2_AL0_EP1_INTERVAL,                  /*!< bInterval */
/********************************************** Interface 3 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x03,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x02,                                       /*!< bNumEndpoints */
    0xff,                                       /*!< bInterfaceClass */
    0x00,                                       /*!< bInterfaceSubClass */
    0x00,                                       /*!< bInterfaceProtocol */
    0x07,                                       /*!< iInterface */
/********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF3_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF3_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF3_AL0_EP0_INTERVAL,                  /*!< bInterval */
/********************************************** Endpoint 1 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF3_AL0_EP1_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF3_AL0_EP1_SIZE),               /*!< wMaxPacketSize */
    USBD_IF3_AL0_EP1_INTERVAL,                  /*!< bInterval */
/********************************************** Language ID String Descriptor */
    0x04,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    WBVAL(USBD_LANGID_STRING),                  /*!< wLangID0 */
/********************************************** String 1 Descriptor */
/* Cherry USB */
    0x16,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x43, 0x00,                                 /*!< 'C' wcChar0 */
    0x68, 0x00,                                 /*!< 'h' wcChar1 */
    0x65, 0x00,                                 /*!< 'e' wcChar2 */
    0x72, 0x00,                                 /*!< 'r' wcChar3 */
    0x72, 0x00,                                 /*!< 'r' wcChar4 */
    0x79, 0x00,                                 /*!< 'y' wcChar5 */
    0x20, 0x00,                                 /*!< ' ' wcChar6 */
    0x55, 0x00,                                 /*!< 'U' wcChar7 */
    0x53, 0x00,                                 /*!< 'S' wcChar8 */
    0x42, 0x00,                                 /*!< 'B' wcChar9 */
/********************************************** String 2 Descriptor */
/* Eastsoft CherryUSB HID CDC WINUSB demo */
    0x4e,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x45, 0x00,                                 /*!< 'E' wcChar0 */
    0x61, 0x00,                                 /*!< 'a' wcChar1 */
    0x73, 0x00,                                 /*!< 's' wcChar2 */
    0x74, 0x00,                                 /*!< 't' wcChar3 */
    0x73, 0x00,                                 /*!< 's' wcChar4 */
    0x6f, 0x00,                                 /*!< 'o' wcChar5 */
    0x66, 0x00,                                 /*!< 'f' wcChar6 */
    0x74, 0x00,                                 /*!< 't' wcChar7 */
    0x20, 0x00,                                 /*!< ' ' wcChar8 */
    0x43, 0x00,                                 /*!< 'C' wcChar9 */
    0x68, 0x00,                                 /*!< 'h' wcChar10 */
    0x65, 0x00,                                 /*!< 'e' wcChar11 */
    0x72, 0x00,                                 /*!< 'r' wcChar12 */
    0x72, 0x00,                                 /*!< 'r' wcChar13 */
    0x79, 0x00,                                 /*!< 'y' wcChar14 */
    0x55, 0x00,                                 /*!< 'U' wcChar15 */
    0x53, 0x00,                                 /*!< 'S' wcChar16 */
    0x42, 0x00,                                 /*!< 'B' wcChar17 */
    0x20, 0x00,                                 /*!< ' ' wcChar18 */
    0x48, 0x00,                                 /*!< 'H' wcChar19 */
    0x49, 0x00,                                 /*!< 'I' wcChar20 */
    0x44, 0x00,                                 /*!< 'D' wcChar21 */
    0x20, 0x00,                                 /*!< ' ' wcChar22 */
    0x43, 0x00,                                 /*!< 'C' wcChar23 */
    0x44, 0x00,                                 /*!< 'D' wcChar24 */
    0x43, 0x00,                                 /*!< 'C' wcChar25 */
    0x20, 0x00,                                 /*!< ' ' wcChar26 */
    0x57, 0x00,                                 /*!< 'W' wcChar27 */
    0x49, 0x00,                                 /*!< 'I' wcChar28 */
    0x4e, 0x00,                                 /*!< 'N' wcChar29 */
    0x55, 0x00,                                 /*!< 'U' wcChar30 */
    0x53, 0x00,                                 /*!< 'S' wcChar31 */
    0x42, 0x00,                                 /*!< 'B' wcChar32 */
    0x20, 0x00,                                 /*!< ' ' wcChar33 */
    0x64, 0x00,                                 /*!< 'd' wcChar34 */
    0x65, 0x00,                                 /*!< 'e' wcChar35 */
    0x6d, 0x00,                                 /*!< 'm' wcChar36 */
    0x6f, 0x00,                                 /*!< 'o' wcChar37 */
/********************************************** String 3 Descriptor */
/* 202210201641 */
    0x1a,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x32, 0x00,                                 /*!< '2' wcChar0 */
    0x30, 0x00,                                 /*!< '0' wcChar1 */
    0x32, 0x00,                                 /*!< '2' wcChar2 */
    0x32, 0x00,                                 /*!< '2' wcChar3 */
    0x31, 0x00,                                 /*!< '1' wcChar4 */
    0x30, 0x00,                                 /*!< '0' wcChar5 */
    0x32, 0x00,                                 /*!< '2' wcChar6 */
    0x30, 0x00,                                 /*!< '0' wcChar7 */
    0x31, 0x00,                                 /*!< '1' wcChar8 */
    0x36, 0x00,                                 /*!< '6' wcChar9 */
    0x34, 0x00,                                 /*!< '4' wcChar10 */
    0x31, 0x00,                                 /*!< '1' wcChar11 */
/********************************************** String 4 Descriptor */
/* cdc control interface */
    0x2c,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x63, 0x00,                                 /*!< 'c' wcChar0 */
    0x64, 0x00,                                 /*!< 'd' wcChar1 */
    0x63, 0x00,                                 /*!< 'c' wcChar2 */
    0x20, 0x00,                                 /*!< ' ' wcChar3 */
    0x63, 0x00,                                 /*!< 'c' wcChar4 */
    0x6f, 0x00,                                 /*!< 'o' wcChar5 */
    0x6e, 0x00,                                 /*!< 'n' wcChar6 */
    0x74, 0x00,                                 /*!< 't' wcChar7 */
    0x72, 0x00,                                 /*!< 'r' wcChar8 */
    0x6f, 0x00,                                 /*!< 'o' wcChar9 */
    0x6c, 0x00,                                 /*!< 'l' wcChar10 */
    0x20, 0x00,                                 /*!< ' ' wcChar11 */
    0x69, 0x00,                                 /*!< 'i' wcChar12 */
    0x6e, 0x00,                                 /*!< 'n' wcChar13 */
    0x74, 0x00,                                 /*!< 't' wcChar14 */
    0x65, 0x00,                                 /*!< 'e' wcChar15 */
    0x72, 0x00,                                 /*!< 'r' wcChar16 */
    0x66, 0x00,                                 /*!< 'f' wcChar17 */
    0x61, 0x00,                                 /*!< 'a' wcChar18 */
    0x63, 0x00,                                 /*!< 'c' wcChar19 */
    0x65, 0x00,                                 /*!< 'e' wcChar20 */
/********************************************** String 5 Descriptor */
/* cdc data interface */
    0x26,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x63, 0x00,                                 /*!< 'c' wcChar0 */
    0x64, 0x00,                                 /*!< 'd' wcChar1 */
    0x63, 0x00,                                 /*!< 'c' wcChar2 */
    0x20, 0x00,                                 /*!< ' ' wcChar3 */
    0x64, 0x00,                                 /*!< 'd' wcChar4 */
    0x61, 0x00,                                 /*!< 'a' wcChar5 */
    0x74, 0x00,                                 /*!< 't' wcChar6 */
    0x61, 0x00,                                 /*!< 'a' wcChar7 */
    0x20, 0x00,                                 /*!< ' ' wcChar8 */
    0x69, 0x00,                                 /*!< 'i' wcChar9 */
    0x6e, 0x00,                                 /*!< 'n' wcChar10 */
    0x74, 0x00,                                 /*!< 't' wcChar11 */
    0x65, 0x00,                                 /*!< 'e' wcChar12 */
    0x72, 0x00,                                 /*!< 'r' wcChar13 */
    0x66, 0x00,                                 /*!< 'f' wcChar14 */
    0x61, 0x00,                                 /*!< 'a' wcChar15 */
    0x63, 0x00,                                 /*!< 'c' wcChar16 */
    0x65, 0x00,                                 /*!< 'e' wcChar17 */
/********************************************** String 6 Descriptor */
/* hid interface */
    0x1c,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x68, 0x00,                                 /*!< 'h' wcChar0 */
    0x69, 0x00,                                 /*!< 'i' wcChar1 */
    0x64, 0x00,                                 /*!< 'd' wcChar2 */
    0x20, 0x00,                                 /*!< ' ' wcChar3 */
    0x69, 0x00,                                 /*!< 'i' wcChar4 */
    0x6e, 0x00,                                 /*!< 'n' wcChar5 */
    0x74, 0x00,                                 /*!< 't' wcChar6 */
    0x65, 0x00,                                 /*!< 'e' wcChar7 */
    0x72, 0x00,                                 /*!< 'r' wcChar8 */
    0x66, 0x00,                                 /*!< 'f' wcChar9 */
    0x61, 0x00,                                 /*!< 'a' wcChar10 */
    0x63, 0x00,                                 /*!< 'c' wcChar11 */
    0x65, 0x00,                                 /*!< 'e' wcChar12 */
/********************************************** String 7 Descriptor */
/* winusb interface */
    0x22,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x77, 0x00,                                 /*!< 'w' wcChar0 */
    0x69, 0x00,                                 /*!< 'i' wcChar1 */
    0x6e, 0x00,                                 /*!< 'n' wcChar2 */
    0x75, 0x00,                                 /*!< 'u' wcChar3 */
    0x73, 0x00,                                 /*!< 's' wcChar4 */
    0x62, 0x00,                                 /*!< 'b' wcChar5 */
    0x20, 0x00,                                 /*!< ' ' wcChar6 */
    0x69, 0x00,                                 /*!< 'i' wcChar7 */
    0x6e, 0x00,                                 /*!< 'n' wcChar8 */
    0x74, 0x00,                                 /*!< 't' wcChar9 */
    0x65, 0x00,                                 /*!< 'e' wcChar10 */
    0x72, 0x00,                                 /*!< 'r' wcChar11 */
    0x66, 0x00,                                 /*!< 'f' wcChar12 */
    0x61, 0x00,                                 /*!< 'a' wcChar13 */
    0x63, 0x00,                                 /*!< 'c' wcChar14 */
    0x65, 0x00,                                 /*!< 'e' wcChar15 */
/********************************************** Device Qualifier Descriptor */
    0x0a,                                       /*!< bLength */
    0x06,                                       /*!< bDescriptorType */
    WBVAL(USBD_VERSION),                        /*!< bcdUSB */
    0x00,                                       /*!< bDeviceClass */
    0x00,                                       /*!< bDeviceSubClass */
    0x00,                                       /*!< bDeviceProtocol */
    0x40,                                       /*!< bMaxPacketSize0 */
    0x01,                                       /*!< bNumConfigurations */
    0x00,                                       /*!< bReserved */
    0x00
};




/*!< USBD HID REPORT 0 Descriptor */
const unsigned char usbd_hid_0_report_descriptor[USBD_IF2_AL0_HID_REPORT_DESC_SIZE] = {
    0x00,
    0xC0    /* END_COLLECTION */
};



/*******************************************************END OF FILE*************/
