/**********************************************************************************
 *
 * @file    shell.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef QSYS_Q_SHELL_H
#define QSYS_Q_SHELL_H

/* Includes ------------------------------------------------------------------ */

#include "stdio.h"

/* Exported Macros ----------------------------------------------------------- */

#define USE_Q_SHELL_FUNCTION 1

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

void show_version(void);

#if USE_Q_SHELL_FUNCTION

/* Exported Types ------------------------------------------------------------ */

typedef const struct
{
    const char     *name;
    const char     *desc;
    void           *addr;
    const char     *typedesc;
} qsh_record_t;

/* Exported Macros ----------------------------------------------------------- */

#define QSH_FUN_REG(name, desc)                                                 \
    static const   char  s_qsh_fun_##name##_name[]  = #name;                          \
    static const   char  s_qsh_fun_##name##_desc[]  = desc;                           \
    qsh_record_t s_qsh_fun_##name##_record  __attribute__((section("g_qShellFunTab"))) =  \
            {                                                                               \
                                                                                            s_qsh_fun_##name##_name,                                                      \
                                                                                            s_qsh_fun_##name##_desc,                                                      \
                                                                                            (void *)&name,                                                              \
                                                                                            0                                                                           \
            }

#define QSH_VAR_REG(name, desc,typedesc)                                       \
    static const   char  s_qsh_var_##name##_name[] = #name;                          \
    static const   char  s_qsh_var_##name##_desc[] = desc;                           \
    static const   char  s_qsh_var_##name##_typedesc[] = typedesc;                   \
    qsh_record_t s_qsh_var_##name##_record  __attribute__((section("g_qShellVarTab"))) = \
            {                                                                              \
                                                                                           s_qsh_var_##name##_name,                                                     \
                                                                                           s_qsh_var_##name##_desc,                                                     \
                                                                                           (void *)&name,                                                             \
                                                                                           s_qsh_var_##name##_typedesc                                                  \
            }

/* Exported Functions -------------------------------------------------------- */

unsigned int Q_Sh_CmdHandler(unsigned int IfCtrl, char *CmdStr);

#else

#define QSH_FUN_REG(name, desc)
#define QSH_VAR_REG(name, desc)
unsigned int Q_Sh_CmdHandler(unsigned int IfCtrl, char *CmdStr);

#endif /*USE_Q_SHELL_FUNCTION*/

#endif /*QSYS_Q_SHELL_H*/


#if USE_Q_SHELL_FUNCTION

    /* Public Variables ---------------------------------------------------------- */

    extern int g_qShellFunTab$$Base;
    extern int g_qShellFunTab$$Limit;
    extern int g_qShellVarTab$$Base;
    extern int g_qShellVarTab$$Limit;

#endif /*USE_Q_SHELL_FUNCTION*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
