/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes-------------------------------------------------------------------*/
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

void usb_dc_low_level_init(void)
{

}

/**
  * @brief user_system_config system configuration.
  * @param none
  * @retval none
  */
static void user_system_config(void)
{
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    md_cmu_enable_usbck48();/*USB 48M使能*/
    md_csu_enable_auto();
    md_csu_enable_cnt();
    MD_SYSCFG_LOCK();
    md_rmu_reset_periperal(MD_RMU_PERH_USB);
    md_init_1ms_tick();
    __enable_irq();

    return;
}

static void gpio_init(void)
{
    md_gpio_init_t gpio_init;

    /* Initialize LED pin */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(LED_PORT, LED_PIN, &gpio_init);

    return;
}

/**
  * @brief main.
  * @param none
  * @retval none
  */
int main(void)
{
    uint32_t last_busy_tick = 0U;

    user_system_config();

    gpio_init();

    md_delay_1us(20);

    cdc_acm_hid_winusb_descriptor_init();

    while (1)
    {
        if (((md_get_tick()) / 1000) & 0x1)
            md_gpio_set_pin_high(LED_PORT, LED_PIN);
        else
            md_gpio_set_pin_low(LED_PORT, LED_PIN);

        if (g_configed_flag)
        {
            usb_dev_loop();

            if (g_hid_boot_ep_flag == 0U)
            {
                if ((md_get_tick() - last_busy_tick) > 1000)
                {
                    if (g_jump2boot_flag)
                    {
                        g_jump2boot_flag = 0;

                        __disable_irq();

                        MD_SYSCFG_UNLOCK();
                        md_syscfg_set_cpu_boot_addr(0x0);
                        MD_SYSCFG_LOCK();

                        __enable_irq();

                        md_rmu_reset_system();
                    }
                }
            }
            else
            {
                last_busy_tick = md_get_tick();
            }
        }
    }
}

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE ****/
