/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-02-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __APP_UPDATE_H__
#define __APP_UPDATE_H__

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/

/* Includes ------------------------------------------------------------------ */
#include "md_msc.h"
#include "es32vf2264.h"
#include "main.h"

/* Exported Macros ----------------------------------------------------------- */
/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern uint32_t g_boot_complete;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
uint8_t app_flash_write(uint32_t addr, const uint8_t *data, uint32_t data_length);
void app_flash_info(uint32_t *start_addr, uint32_t *size);
uint8_t app_flash_erase_area(uint32_t addr, uint32_t size);

#ifdef __cplusplus
}
#endif /*__cplusplus*/
#endif /*__APP_UPDATE_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

