/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "usbd_core.h"
#include "usbd_msc.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
static struct usbd_interface s_msc_intf;
static uint8_t s_configed_flag = 1;

/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/*******************************************************START OF ChryUSB_Configurator Generation*************/
#ifndef WBVAL
    #define WBVAL(x) (unsigned char)((x) & 0xFF), (unsigned char)(((x) >> 8) & 0xFF)
#endif/*WBVAL*/

/*!< USBD CONFIG */
#define USBD_VERSION 0x0200
#define USBD_PRODUCT_VERSION 0x0001
#define USBD_VID 0xffff
#define USBD_PID 0xffff
#define USBD_MAX_POWER 0xfa
#define USBD_LANGID_STRING 1033
#define USBD_CONFIG_DESCRIPTOR_SIZE 32

/*!< USBD ENDPOINT CONFIG */

#define USBD_IF0_AL0_EP0_ADDR 0x01
#define USBD_IF0_AL0_EP0_SIZE 0x40
#define USBD_IF0_AL0_EP0_INTERVAL 0x00

#define USBD_IF0_AL0_EP1_ADDR 0x81
#define USBD_IF0_AL0_EP1_SIZE 0x40
#define USBD_IF0_AL0_EP1_INTERVAL 0x00

/*!< USBD HID CONFIG */

/*!< USBD Descriptor */
const unsigned char usbd_descriptor[] =
{
    /********************************************** Device Descriptor */
    0x12,                                       /*!< bLength */
    0x01,                                       /*!< bDescriptorType */
    WBVAL(USBD_VERSION),                        /*!< bcdUSB */
    0x00,                                       /*!< bDeviceClass */
    0x00,                                       /*!< bDeviceSubClass */
    0x00,                                       /*!< bDeviceProtocol */
    0x40,                                       /*!< bMaxPacketSize */
    WBVAL(USBD_VID),                            /*!< idVendor */
    WBVAL(USBD_PID),                            /*!< idProduct */
    WBVAL(USBD_PRODUCT_VERSION),                /*!< bcdDevice */
    0x01,                                       /*!< iManufacturer */
    0x02,                                       /*!< iProduct */
    0x03,                                       /*!< iSerial */
    0x01,                                       /*!< bNumConfigurations */
    /********************************************** Config Descriptor */
    0x09,                                       /*!< bLength */
    0x02,                                       /*!< bDescriptorType */
    WBVAL(USBD_CONFIG_DESCRIPTOR_SIZE),         /*!< wTotalLength */
    0x01,                                       /*!< bNumInterfaces */
    0x01,                                       /*!< bConfigurationValue */
    0x00,                                       /*!< iConfiguration */
    0xa0,                                       /*!< bmAttributes */
    USBD_MAX_POWER,                             /*!< bMaxPower */
    /********************************************** Interface 0 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x02,                                       /*!< bNumEndpoints */
    0x08,                                       /*!< bInterfaceClass */
    0x06,                                       /*!< bInterfaceSubClass */
    0x50,                                       /*!< bInterfaceProtocol */
    0x00,                                       /*!< iInterface */
    /********************************************** Class Specific Descriptor of MSC */
    /********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF0_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF0_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF0_AL0_EP0_INTERVAL,                  /*!< bInterval */
    /********************************************** Endpoint 1 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF0_AL0_EP1_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF0_AL0_EP1_SIZE),               /*!< wMaxPacketSize */
    USBD_IF0_AL0_EP1_INTERVAL,                  /*!< bInterval */
    /********************************************** Language ID String Descriptor */
    0x04,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    WBVAL(USBD_LANGID_STRING),                  /*!< wLangID0 */
    /********************************************** String 1 Descriptor */
    /* essemi */
    0x0e,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x65, 0x00,                                 /*!< 'e' wcChar0 */
    0x73, 0x00,                                 /*!< 's' wcChar1 */
    0x73, 0x00,                                 /*!< 's' wcChar2 */
    0x65, 0x00,                                 /*!< 'e' wcChar3 */
    0x6d, 0x00,                                 /*!< 'm' wcChar4 */
    0x69, 0x00,                                 /*!< 'i' wcChar5 */
    /********************************************** String 2 Descriptor */
    /* demo */
    0x0a,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x64, 0x00,                                 /*!< 'd' wcChar0 */
    0x65, 0x00,                                 /*!< 'e' wcChar1 */
    0x6d, 0x00,                                 /*!< 'm' wcChar2 */
    0x6f, 0x00,                                 /*!< 'o' wcChar3 */
    /********************************************** String 3 Descriptor */
    /* 202302071805 */
    0x1a,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x32, 0x00,                                 /*!< '2' wcChar0 */
    0x30, 0x00,                                 /*!< '0' wcChar1 */
    0x32, 0x00,                                 /*!< '2' wcChar2 */
    0x33, 0x00,                                 /*!< '3' wcChar3 */
    0x30, 0x00,                                 /*!< '0' wcChar4 */
    0x32, 0x00,                                 /*!< '2' wcChar5 */
    0x30, 0x00,                                 /*!< '0' wcChar6 */
    0x37, 0x00,                                 /*!< '7' wcChar7 */
    0x31, 0x00,                                 /*!< '1' wcChar8 */
    0x38, 0x00,                                 /*!< '8' wcChar9 */
    0x30, 0x00,                                 /*!< '0' wcChar10 */
    0x35, 0x00,                                 /*!< '5' wcChar11 */
    /********************************************** Device Qualifier Descriptor */
    0x0a,                                       /*!< bLength */
    0x06,                                       /*!< bDescriptorType */
    WBVAL(USBD_VERSION),                        /*!< bcdUSB */
    0x00,                                       /*!< bDeviceClass */
    0x00,                                       /*!< bDeviceSubClass */
    0x00,                                       /*!< bDeviceProtocol */
    0x40,                                       /*!< bMaxPacketSize0 */
    0x01,                                       /*!< bNumConfigurations */
    0x00,                                       /*!< bReserved */
    0x00
};
/*******************************************************END OF ChryUSB_Configurator Generation*************/

void usbd_event_handler(uint8_t busid, uint8_t event)
{
    switch (event)
    {
        case USBD_EVENT_RESET:
            break;

        case USBD_EVENT_CONNECTED:
            break;

        case USBD_EVENT_DISCONNECTED:
            break;

        case USBD_EVENT_RESUME:
            break;

        case USBD_EVENT_SUSPEND:
            break;

        case USBD_EVENT_CONFIGURED:
        {
            s_configed_flag = 1;

            break;
        }

        case USBD_EVENT_SET_REMOTE_WAKEUP:
            break;

        case USBD_EVENT_CLR_REMOTE_WAKEUP:
            break;

        default:
            break;
    }
}

/**
  * @brief            cdc hid winusb init
  * @pre              none
  * @param[in]        none
  * @retval           none
  */
void usb_descriptor_init(void)
{
    init_fat12_fs();

    usbd_desc_register(0, usbd_descriptor);

    usbd_add_interface(0, usbd_msc_init_intf(0, &s_msc_intf, USBD_IF0_AL0_EP0_ADDR, USBD_IF0_AL0_EP1_ADDR));

    s_configed_flag = 0;
    usbd_initialize(0, 0, usbd_event_handler);

    while (!s_configed_flag);
}

void usbd_msc_get_cap(uint8_t busid, uint8_t lun, uint32_t *block_num, uint32_t *block_size)
{
    *block_num = DISK_BLOCK_NR;
    *block_size = DISK_BLOCK_SIZE;
}

int usbd_msc_sector_read(uint8_t busid, uint8_t lun, uint32_t sector, uint8_t *buffer, uint32_t length)
{
    uint32_t i, addr_s;

    addr_s = SECTION_ADDR(sector);

    for (i = 0; i < length; i++)
        buffer[i] = *((uint8_t *)(addr_s + i));

    return 0;
}

int usbd_msc_sector_write(uint8_t busid, uint8_t lun, uint32_t sector, uint8_t *buffer, uint32_t length)
{
    es_iap_program_words(SECTION_ADDR(sector), buffer, length, 1);

    g_write_fatfs_time_ms = md_get_tick();

    if (g_write_fatfs_time_ms == 0)
        g_write_fatfs_time_ms = 1;

    return 0;
}

/*******************************************************END OF FILE*************/
