/*******************************************************************************
* Function Name  : fft_64
* Description    : FFT 64 filter
* Input          : - a0: Ouput freq data (f)
*                  - a1: Input time data (s)
*                  - a2: the number of input samples
* Output         : None
* Return         : None
*******************************************************************************/

.equ NPT, 64

.extern FFT_TABLE

.global cfft_r4_64
.type   cfft_r4_64, %function
cfft_r4_64:
	add sp,sp,-40
	sw	s0, 0(sp)
    sw	s1, 4(sp)
	sw  ra, 8(sp)
    sw	a0, 12(sp)
    sw	a1, 16(sp)
    sw	a2, 20(sp)

	/*
	x5-x12 -> A B C D (complex)
	x13    -> index
	x14    -> tmp
	x15    -> out data
	*/
    mv x13, zero
	mv x15, a0

preloop:
    lw	x14, 16(sp)
	la	x5,BN_TABLE
	add x5,x5,x13
	lbu  x6,(x5)
	slli x6,x6,2
	add x14,x14,x6
	lh  x5,0(x14)       //Ar
	lh  x6,2(x14)		//Ai
	lh  x9,0+NPT(x14)	//Cr
	lh  x10,2+NPT(x14)	//Ci
	lh  x7,0+NPT*2(x14)	//Br
	lh  x8,2+NPT*2(x14)	//Bi
	lh  x11,0+NPT*3(x14)//Dr
	lh  x12,2+NPT*3(x14)//Di
	
	// (C,D) = (C+D, C-D)
	add	x9, x9, x11   	//Cr+Dr
	add	x10, x10, x12 	//Ci+Di
	slli x14,x11,1
	sub x11, x9, x14	// (Cr+Dr)-2*Dr
	slli x14,x12,1
	sub x12, x10,x14	// (Ci+Di)-2*Di
	
	// (A,B) = (A+B)/4, (A-B)/4
	srai x5,x5,2		// Ar/4
	srai x6,x6,2		// Ai/4
	srai x14,x7,2
	add x5,x5,x14		// Ar/4+Br/4
	srai x14,x8,2
	add x6,x6,x14		// Ai/4+Bi/4
	srai x14,x7,1  		// Bi/2
	sub x7,x5,x14  		// (Ar/4+Br/4)-Bi/2
	srai x14,x8,1  		// Br/2
	sub x8,x6,x14  		// (Ai/4+Bi/4)-Br/2
	// (A,C) = (A+C)/4, (A-C)/4
	// Ar=Ar/4+Cr/4 Ai=Ai/4+Ci/4
	srai x14,x9,2
	add x5,x5,x14 		// Ar/4+Cr/4
	srai x14,x10,2
	add x6,x6,x14		// Ai/4+Ci/4
	srai x14,x9,1
	sub x9,x5,x14		// Cr=(Ar/4+Cr/4)-Cr/2
	srai x14,x10,1
	sub x10,x6,x14		// Ci=(Ai/4+Ci/4)-Ci/2
	// (B,D) = (B-i*D)/4, (B+i*D)/4
	// Br=Br/4+Di/4 Bi=Bi/4-Dr/4
	// Dr=Br/4-Di/4 Di=Bi/4+Dr/4
	srai x14,x12,2
	add x7,x7,x14 		// Bi+Di/4
	srai x14,x11,2
	sub x8,x8,x14 		// Br+Dr/4
	srai x14,x12,1
	sub x12,x7,x14		// (Bi/4+Di/4)-Di/2
	srai x14,x11,1
	add x11,x8,x14		// (Br/4+Dr/4)-Dr/2
	
	
	sh  x5,0(x15)
	sh  x6,2(x15)
	sh  x7,4(x15)
	sh  x8,6(x15)
	sh  x9,8(x15)
	sh  x10,10(x15)
	sh  x12,12(x15)  //inversion here
	sh  x11,14(x15)
	add x15,x15,16
	
	add x13,x13,1
	li x14,16   // NPT/4
	blt x13,x14,preloop
	
    lw	x15, 12(sp) //restore data pointer
	li  x13,16      //index
	li  x1,4 		
	sw  x1,28(sp)   //butternbr=64/16
	// load FFT Table
	la x1,FFT_TABLE
    sw x1, 24(sp)

	/*
	x5-x12 -> data
	x13    -> index
	x14    -> tmp
	x15    -> data ptr
	x1     -> tmp2
	*/
passloop:
	lw x1,28(sp)
    sw x15, 32(sp)
	sw x1, 36(sp)
	slli x14,x13,1
	add x14,x14,x13
	add x15,x15,x14
	li x14,1<<16
	sub x1,x1,x14
	
grouploop:

	slli x14,x13,16-2
	add x1,x1,x14
	sw x1,28(sp)
	
butterloop:
	/* 1 */
	lh x5,0(x15)
	lh x6,2(x15)
	sub x15,x15,x13
	
	lw x1,24(sp)
	lh x11,0(x1)
	lh x12,2(x1)
	
	sub x1,x6,x5
	mul x14,x1,x12
	slli x12,x12,1
	add x1,x11,x12
	mul x12,x6,x11
	add x12,x12,x14
	mul x11,x5,x1
	add x11,x11,x14
	
	/***2***/
	lh x5,0(x15)
	lh x6,2(x15)
	sub x15,x15,x13
	
	lw x1,24(sp)
	lh x9,4(x1)
	lh x10,6(x1)
	
	sub x1,x6,x5
	mul x14,x1,x10
	slli x10,x10,1
	add x1,x9,x10
	mul x10,x6,x9
	add x10,x10,x14
	mul x9,x5,x1
	add x9,x9,x14
	
	/***3***/
	lh x5,(x15)
	lh x6,2(x15)
	sub x15,x15,x13
	
	lw x1,24(sp)
	lh x7,8(x1)
	lh x8,10(x1)
	add x1,x1,12
	sw x1,24(sp)
	
	sub x1,x6,x5
	mul x14,x1,x8
	slli x8,x8,1
	add x1,x7,x8
	mul x8,x6,x7
	add x8,x8,x14
	mul x7,x5,x1
	add x7,x7,x14
	
	/***A***/
	lh x5,(x15)
	lh x6,2(x15)
	
	add x9,x9,x11
	add x10,x10,x12
	slli x11,x11,1
	sub x11,x9,x11
	slli x12,x12,1
	sub x12,x10,x12
	
	srai x5,x5,2
	srai x6,x6,2
	srai x1,x7,(2+14)
	add x5,x5,x1
	srai x1,x8,(2+14)
	add x6,x6,x1
	srai x1,x7,(1+14)
	sub x7,x5,x1
	srai x1,x8,(1+14)
	sub x8,x6,x1
	srai x1,x9,(2+14)
	add x5,x5,x1
	srai x1,x10,(2+14)
	add x6,x6,x1
	srai x1,x9,(1+14)
	sub x9,x5,x1
	srai x1,x10,(1+14)
	sub x10,x6,x1
	srai x1,x12,(2+14)
	add x7,x7,x1
	srai x1,x11,(2+14)
	sub x8,x8,x1
	srai x1,x12,(1+14)
	sub x12,x7,x1
	srai x1,x11,(1+14)
	add x11,x8,x1
	
	sh x5,(x15)
	sh x6,2(x15)
	add x15,x15,x13
	sh x7,(x15)
	sh x8,2(x15)
	add x15,x15,x13
	sh x9,(x15)
	sh x10,2(x15)
	add x15,x15,x13
	sh x12,(x15)
	sh x11,2(x15)
	add x15,x15,4
	
	lw x1,28(sp)
	li x14,1<<16
	sub x1,x1,x14
	sw x1,28(sp)
	bge x1,zero,butterloop
	
	slli x14,x13,1
	add x14,x14,x13
	add x15,x15,x14
	//use x5,x6 as temp
	//x1=28(sp) x6=24(sp)
	add x1,x1,-1
	slli x5,x1,16
	beq x5,zero,next
	lw x6,24(sp)
	sub x6,x6,x14
	sw x6,24(sp)
	j grouploop
	next:
	
	lw x15,32(sp)
	lw x1,36(sp)
	slli x13,x13,2
	srai x1,x1,2
	sw x1,28(sp)
	bne x1,zero,passloop
	
	/* return */
	lw	s0, 0(sp)
	lw	s1, 4(sp)
	lw  ra, 8(sp)
	add sp,sp,40
	ret
	
BN_TABLE:
		.byte 0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15
.end
