/*
 * Copyright (c) mlibc & plct lab
 *
 * SPDX-License-Identifier: MIT
 *
 * Change Logs:
 * Date           Author       Notes
 * 2023/06/16     bernard      the first verison
 */

#ifndef MLIBC_SIGNAL_H__
#define MLIBC_SIGNAL_H__

#include <stdint.h>
#include <sys/time.h>

#if 0
#define SIGHUP    1
#define SIGINT    2
#define SIGQUIT   3
#define SIGILL    4
#define SIGTRAP   5
#define SIGABRT   6
#define SIGIOT    SIGABRT
#define SIGBUS    7
#define SIGFPE    8
#define SIGKILL   9

#ifndef SIGUSR1
#define SIGUSR1   10
#endif

#define SIGSEGV   11

#ifndef SIGUSR2
#define SIGUSR2   12
#endif

#define SIGPIPE   13
#define SIGALRM   14
#define SIGTERM   15
#define SIGSTKFLT 16
#define SIGCHLD   17

#ifndef SIGCONT
#define SIGCONT   18
#endif

#ifndef SIGSTOP
#define SIGSTOP   19
#endif
#ifndef SIGTSTP
#define SIGTSTP   20
#endif

#define SIGTTIN   21
#define SIGTTOU   22

#ifndef SIGURG
#define SIGURG    23
#endif

#define SIGXCPU   24
#define SIGXFSZ   25
#define SIGVTALRM 26
#define SIGPROF   27
#define SIGWINCH  28
#ifndef SIGIO
#define SIGIO     29
#endif
#ifndef SIGPOLL
#define SIGPOLL   29
#endif
#define SIGPWR    30
#define SIGSYS    31
#define SIGUNUSED SIGSYS
#endif

#define _NSIG       65

#define SIG_SETMASK 0   /* set mask with sigprocmask() */
#define SIG_BLOCK   1   /* set of signals to block */
#define SIG_UNBLOCK 2   /* set of signals to, well, unblock */

typedef void (*_sig_func_ptr)(int);
typedef unsigned long sigset_t;

#define SIG_DFL ((_sig_func_ptr)0)  /* Default action */
#define SIG_IGN ((_sig_func_ptr)1)  /* Ignore action */
#define SIG_ERR ((_sig_func_ptr)-1) /* Error return */

#define SI_USER     0x01    /* Signal sent by kill(). */
#define SI_QUEUE    0x02    /* Signal sent by sigqueue(). */
#define SI_TIMER    0x03    /* Signal generated by expiration of a
                               timer set by timer_settime(). */
#define SI_ASYNCIO  0x04    /* Signal generated by completion of an
                               asynchronous I/O request. */
#define SI_MESGQ    0x05    /* Signal generated by arrival of a
                               message on an empty message queue. */

#ifdef NEED_SIG_STRUCT
union sigval
{
    int    sival_int;    /* Integer signal value */
    void  *sival_ptr;    /* Pointer signal value */
};

struct sigaction
{
    _sig_func_ptr sa_handler;
    sigset_t sa_mask;
    int sa_flags;
};

struct sigevent
{
    int          sigev_notify;               /* Notification type */
    int          sigev_signo;                /* Signal number */
    union sigval sigev_value;                /* Signal value */
    void         (*sigev_notify_function)( union sigval );
                                             /* Notification function */
    void         *sigev_notify_attributes;   /* Notification Attributes, really pthread_attr_t */
};

struct siginfo
{
    uint16_t si_signo;
    uint16_t si_code;

    union sigval si_value;
};
typedef struct siginfo siginfo_t;
#endif

int sigprocmask (int how, const sigset_t *set, sigset_t *oset);
int sigwait(const sigset_t *set, int *sig);
int raise(int sig);

#endif /*MLIBC_SIGNAL_H__*/
